/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.docusaurus.DocusaurusUtils;
import net.thevpc.nuts.lib.md.util.MdUtils;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFileOrFolder;

public abstract class DocusaurusFile
implements DocusaurusFileOrFolder {
    private final String longId;
    private final String shortId;
    private final String title;
    private final NutsElement config;
    private final int order;

    protected DocusaurusFile(String shortId, String longId, String title, int order, NutsElement config) {
        this.shortId = shortId;
        this.longId = longId;
        this.title = title;
        this.order = order;
        this.config = config;
    }

    public NutsElement getConfig() {
        return this.config;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getLongId() {
        return this.longId;
    }

    @Override
    public String getShortId() {
        return this.shortId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public abstract MdElement getContent(NutsSession var1);

    public String toString() {
        String s = this.longId;
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public String toJSON(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(DocusaurusUtils.indentChars((int)indent));
        sb.append("'").append(MdUtils.escapeString((String)(this.getLongId() + "'")));
        return sb.toString();
    }
}

