/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.docusaurus.Docusaurus2Asciidoctor;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFolder;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusProject;
import net.thevpc.nuts.toolbox.nsh.AbstractNshBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellFileContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVar;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVarListener;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVariables;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.DefaultMimeTypeResolver;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ExprEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.MimeTypeResolver;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateConfig;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class DocusaurusCtrl {
    private DocusaurusProject project;
    private boolean buildPdf;
    private boolean buildWebSite;
    private boolean startWebSite;
    private boolean autoInstallNutsPackages;
    private String ndocVersion;
    private String npmCommandPath;
    private NutsApplicationContext appContext;

    public DocusaurusCtrl(DocusaurusProject project, NutsApplicationContext appContext) {
        this.project = project;
        this.appContext = appContext;
    }

    public boolean isBuildPdf() {
        return this.buildPdf;
    }

    public DocusaurusCtrl setBuildPdf(boolean buildPdf) {
        this.buildPdf = buildPdf;
        return this;
    }

    public boolean isBuildWebSite() {
        return this.buildWebSite;
    }

    public DocusaurusCtrl setBuildWebSite(boolean buildWebSite) {
        this.buildWebSite = buildWebSite;
        return this;
    }

    public boolean isStartWebSite() {
        return this.startWebSite;
    }

    public DocusaurusCtrl setStartWebSite(boolean startWebSite) {
        this.startWebSite = startWebSite;
        return this;
    }

    public void run() {
        Path base = null;
        try {
            base = Paths.get(this.project.getDocusaurusBaseFolder(), new String[0]).normalize().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("invalid Docusaurus Base Folder: " + this.project.getDocusaurusBaseFolder(), e);
        }
        String genSidebarMenuString = this.project.getConfig().getSafeObject("customFields").getSafeObject("docusaurus").getSafe("generateSidebarMenu").toString();
        boolean genSidebarMenu = Boolean.parseBoolean(genSidebarMenuString);
        Path basePath = base;
        Path preProcessor = this.getPreProcessorBaseDir();
        if (Files.isDirectory(preProcessor, new LinkOption[0]) && Files.isRegularFile(preProcessor.resolve("project.nsh"), new LinkOption[0])) {
            Path docs = basePath.resolve("docs");
            if (Files.isDirectory(basePath.resolve("node_modules"), new LinkOption[0]) && Files.isRegularFile(basePath.resolve("docusaurus.config.js"), new LinkOption[0])) {
                this.appContext.getSession().out().printf("clear folder %s%n", new Object[]{docs});
                this.deletePathChildren(docs);
            }
            this.appContext.getSession().out().printf("process template %s -> %s%n", new Object[]{preProcessor, this.getTargetBaseDir()});
            TemplateConfig config = new TemplateConfig().setProjectPath(preProcessor.toString()).setTargetFolder(this.getTargetBaseDir().toString());
            new NFileTemplater(this.appContext).setWorkingDir(base.toString()).setMimeTypeResolver((MimeTypeResolver)new DefaultMimeTypeResolver().setExtensionMimeType("ftex", "text/ftex").setNameMimeType(".docusaurus-folder-config.json", "text/x-json-docusaurus-folder-config")).setDefaultProcessor("text/x-json-docusaurus-folder-config", (TemplateProcessor)new FolderConfigProcessor()).setCustomVarEvaluator((Function)new DocusaurusCustomVarEvaluator(this.project)).processProject(config);
        }
        if (genSidebarMenu) {
            DocusaurusFolder root = this.project.getPhysicalDocsFolder();
            root = new DocusaurusFolder("someSidebar", "someSidebar", 0, this.appContext.getWorkspace().elem().forObject().build(), root.getChildren(), root.getContent(this.appContext.getSession()), this.project.getPhysicalDocsFolderBasePath().toString());
            String s = "module.exports = {\n" + root.toJSON(1) + "\n};";
            if (this.appContext.getSession().isPlainOut()) {
                this.appContext.getSession().out().printf("build sidebar %s%n", new Object[]{base.resolve("sidebars.js")});
                this.appContext.getSession().out().printf("\tusing release folder : %s%n", new Object[]{this.project.getPhysicalDocsFolderBasePath()});
                this.appContext.getSession().out().printf("\tusing config folder  : %s%n", new Object[]{this.project.getPhysicalDocsFolderConfigPath()});
            }
            try {
                Files.write(base.resolve("sidebars.js"), s.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new NutsIOException(this.appContext.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{e}));
            }
        }
        if (this.isBuildPdf() && !this.project.getConfig().getSafeObject("customFields").getSafeObject("asciidoctor").getSafe("path").isNull()) {
            Docusaurus2Asciidoctor d2a = new Docusaurus2Asciidoctor(this.project);
            this.appContext.getSession().out().printf("build adoc file : %s%n", new Object[]{d2a.getAdocFile()});
            d2a.createAdocFile();
            this.appContext.getSession().out().printf("build pdf  file : %s%n", new Object[]{d2a.getPdfFile()});
            d2a.createPdfFile();
        }
        if (this.isBuildWebSite()) {
            this.appContext.getSession().out().printf("build website%n", new Object[0]);
            this.runNativeCommand(base, this.getEffectiveNpmCommandPath(), "run-script", "build");
            String copyBuildPath = this.project.getConfig().getSafeObject("customFields").getSafe("copyBuildPath").asString();
            if (copyBuildPath != null && copyBuildPath.length() > 0) {
                String fromPath = null;
                try {
                    fromPath = base.resolve("build").toRealPath(new LinkOption[0]).toString();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                Path toPath = FileProcessorUtils.toAbsolute((Path)Paths.get(copyBuildPath, new String[0]), (Path)base);
                this.deleteFolderIfFound(toPath, "index.html", "404.html", "sitemap.xml");
                new FileTemplater(this.appContext.getSession()).setWorkingDir(fromPath).setTargetPath(toPath).setMimeTypeResolver(path -> "*/*").processTree(Paths.get(fromPath, new String[0]), null);
            }
        }
        if (this.isStartWebSite()) {
            this.runNativeCommand(base, this.getEffectiveNpmCommandPath(), "start");
        }
    }

    public String getNdocVersion() {
        return this.ndocVersion;
    }

    public DocusaurusCtrl setNdocVersion(String ndocVersion) {
        this.ndocVersion = ndocVersion;
        return this;
    }

    public String getNpmCommandPath() {
        return this.npmCommandPath;
    }

    public DocusaurusCtrl setNpmCommandPath(String npmCommandPath) {
        this.npmCommandPath = npmCommandPath;
        return this;
    }

    public String getEffectiveNpmCommandPath() {
        String npm = this.getNpmCommandPath();
        if (npm == null || npm.trim().isEmpty()) {
            return "npm";
        }
        return npm;
    }

    private void runNativeCommand(Path workFolder, String ... cmd) {
        NutsSession s = this.appContext.getSession();
        this.appContext.getWorkspace().exec().setExecutionType(NutsExecutionType.EMBEDDED).addCommand(cmd).setDirectory(workFolder.toString()).setSession(s).setFailFast(true).getResult();
    }

    private void runCommand(Path workFolder, boolean yes, String ... cmd) {
        NutsSession s = this.appContext.getSession().copy();
        s = yes ? s.setConfirm(NutsConfirmationMode.YES) : s.setConfirm(NutsConfirmationMode.ERROR);
        this.appContext.getWorkspace().exec().addCommand(cmd).setDirectory(workFolder.toString()).setSession(s).setExecutionType(NutsExecutionType.EMBEDDED).setFailFast(true).getResult();
    }

    private boolean deleteFolderIfFound(Path toPath, String ... names) {
        if (!Files.isDirectory(toPath, new LinkOption[0])) {
            return false;
        }
        for (String name : names) {
            if (Files.isRegularFile(toPath.resolve(name), new LinkOption[0])) continue;
            return false;
        }
        this.deletePath(toPath);
        return true;
    }

    private void deletePathChildren(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.list(path).forEach(x -> this.deletePath((Path)x));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void deletePath(Path toPath) {
        try {
            Files.walk(toPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(x -> {
                try {
                    Files.delete(x);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getTargetBaseDir() {
        return Paths.get(this.project.getDocusaurusBaseFolder(), new String[0]);
    }

    private Path getPreProcessorBaseDir() {
        return Paths.get(this.project.getDocusaurusBaseFolder(), new String[0]).resolve(".dir-template");
    }

    public boolean isAutoInstallNutsPackages() {
        return this.autoInstallNutsPackages;
    }

    public DocusaurusCtrl setAutoInstallNutsPackages(boolean autoInstallNutsPackages) {
        this.autoInstallNutsPackages = autoInstallNutsPackages;
        return this;
    }

    private class FolderConfigProcessor
    implements TemplateProcessor {
        public void processStream(InputStream source, OutputStream target, FileTemplater context) {
            throw new IllegalArgumentException("Unsupported");
        }

        public void processPath(Path source, String mimeType, FileTemplater context) {
            NutsObjectElement config = DocusaurusFolder.ofFolder(DocusaurusCtrl.this.appContext.getSession(), source.getParent(), Paths.get(context.getRootDirRequired(), new String[0]).resolve("docs"), DocusaurusCtrl.this.getPreProcessorBaseDir().resolve("src"), 0).getConfig().getSafeObject("type");
            if ("javadoc".equals(config.getSafeString("name")) || "doc".equals(config.getSafeString("name"))) {
                String[] sources = (String[])config.asSafeObject().getSafeArray("sources").stream().map(NutsElement::asSafeString).filter(Objects::nonNull).toArray(String[]::new);
                if (sources.length == 0) {
                    throw new IllegalArgumentException("missing doc sources in " + source);
                }
                String[] packages = (String[])config.asSafeObject().getSafeArray("packages").stream().map(NutsElement::asSafeString).filter(Objects::nonNull).toArray(String[]::new);
                String target = context.getPathTranslator().translatePath(source.getParent().toString());
                if (target == null) {
                    throw new IllegalArgumentException("invalid source " + source.getParent());
                }
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("ndoc" + (DocusaurusCtrl.this.getNdocVersion() == null || DocusaurusCtrl.this.getNdocVersion().isEmpty() ? "" : "#" + DocusaurusCtrl.this.getNdocVersion()));
                cmd.add("--backend=docusaurus");
                for (String s : sources) {
                    s = context.processString(s, "application/x-file-placeholder-dollars");
                    cmd.add("--source");
                    cmd.add(FileProcessorUtils.toAbsolutePath((Path)Paths.get(s, new String[0]), (Path)source.getParent()).toString());
                }
                for (String s : packages) {
                    s = context.processString(s, "application/x-file-placeholder-dollars");
                    cmd.add("--package");
                    cmd.add(s);
                }
                cmd.add("--target");
                cmd.add(target);
                FileProcessorUtils.mkdirs((Path)Paths.get(target, new String[0]));
                DocusaurusCtrl.this.runCommand(Paths.get(target, new String[0]), DocusaurusCtrl.this.autoInstallNutsPackages, cmd.toArray(new String[0]));
            }
        }

        public String toString() {
            return "DocusaurusFolderConfig";
        }
    }

    private static class DocusaurusCustomVarEvaluator
    implements Function<String, Object> {
        NutsElement config;
        String projectName;
        String projectTitle;

        public DocusaurusCustomVarEvaluator(DocusaurusProject project) {
            this.config = project.getConfig();
            this.projectName = project.getProjectName();
            this.projectTitle = project.getTitle();
        }

        @Override
        public Object apply(String varName) {
            String[] a;
            switch (varName) {
                case "projectName": {
                    return this.projectName;
                }
                case "projectTitle": {
                    return this.projectTitle;
                }
            }
            for (String s : a = (String[])Arrays.stream(varName.split("[./]")).map(String::trim).filter(x -> !x.isEmpty()).toArray(String[]::new)) {
                this.config = this.config.asSafeObject().getSafe(s);
            }
            if (this.config.isNull()) {
                return null;
            }
            if (this.config.isString()) {
                return this.config.asString();
            }
            if (this.config.isArray()) {
                return this.config.asArray().stream().map(x -> x.toString()).toArray(String[]::new);
            }
            return this.config.asString();
        }
    }

    private static class NFileTemplater
    extends FileTemplater {
        public NFileTemplater(NutsApplicationContext appContext) {
            super(appContext.getSession());
            this.setDefaultExecutor("text/ntemplate-nsh-project", new NshEvaluator(appContext, this));
            this.setProjectFileName("project.nsh");
        }

        public void executeProjectFile(Path path, String mimeTypesString) {
            this.executeRegularFile(path, "text/ntemplate-nsh-project");
        }
    }

    private static class NshEvaluator
    implements ExprEvaluator {
        private NutsApplicationContext appContext;
        private JShell shell;
        private FileTemplater fileTemplater;

        public NshEvaluator(NutsApplicationContext appContext, final FileTemplater fileTemplater) {
            this.appContext = appContext;
            this.fileTemplater = fileTemplater;
            this.shell = new JShell(appContext, new String[0]);
            this.shell.setSession(this.shell.getSession().copy());
            this.shell.getRootContext().vars().addVarListener(new JShellVarListener(){

                public void varAdded(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varValueUpdated(JShellVar jShellVar, String oldValue, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varRemoved(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), null);
                }
            });
            this.shell.getRootContext().builtins().set((JShellBuiltin)new AbstractNshBuiltin("process", 10){

                public int execImpl(String[] args, JShellExecutionContext context) {
                    if (args.length != 1) {
                        context.err().println(this.getName() + " : invalid arguments count");
                        return 1;
                    }
                    String pathString = args[0];
                    fileTemplater.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString((Object)pathString) + ")");
                    fileTemplater.executeRegularFile(Paths.get(pathString, new String[0]), null);
                    return 0;
                }
            });
        }

        public void setVar(String varName, String newValue) {
            this.fileTemplater.getLog().debug("eval", varName + "=" + StringUtils.toLiteralString((Object)newValue));
            this.fileTemplater.setVar(varName, (Object)newValue);
        }

        public Object eval(String content, FileTemplater context) {
            NutsSession session = this.shell.getSession();
            NutsMemoryPrintStream out = session.getWorkspace().io().createMemoryPrintStream();
            session.setTerminal(session.getWorkspace().term().createTerminal((InputStream)new ByteArrayInputStream(new byte[0]), (NutsPrintStream)out, (NutsPrintStream)out));
            JShellFileContext ctx = this.shell.createSourceFileContext(this.shell.getRootContext(), context.getSourcePath().orElseGet(() -> "nsh"), new String[0]);
            this.shell.executeString(content, ctx);
            return out.toString();
        }

        public String toString() {
            return "nsh";
        }
    }
}

