/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.convert.Adoc2Pdf;
import net.thevpc.nuts.lib.md.convert.Adoc2PdfConfig;
import net.thevpc.nuts.toolbox.docusaurus.Docusaurus2Adoc;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusProject;

public class Docusaurus2Asciidoctor {
    protected Path pdfFile;
    protected boolean generatePdf;
    protected DocusaurusProject project;

    public Docusaurus2Asciidoctor(DocusaurusProject project) {
        this.project = project;
    }

    public Docusaurus2Asciidoctor(File project, NutsSession session) {
        this.project = new DocusaurusProject(project.getPath(), null, session);
    }

    public Path getPdfFile() {
        return new Adoc2Pdf().getPdfFile(this.getAdoc2PdfConfig());
    }

    public Path getAdocFile() {
        String pn0;
        String asciiDoctorBaseFolder = this.getAsciiDoctorBaseFolder();
        String pdfOutput = this.getAsciiDoctorConfig().getSafeObject("pdf").getSafeString("output");
        String pn = null;
        if (pdfOutput != null && pdfOutput.endsWith(".pdf")) {
            pn0 = Paths.get(pdfOutput, new String[0]).getFileName().toString();
            if ((pn0 = pn0.substring(0, pn0.length() - 4)).length() > 0) {
                pn = pn0;
            }
        }
        if (pn == null && (pn0 = this.project.getProjectName()) != null && pn0.length() > 0) {
            pn = pn0;
        }
        if (pn == null) {
            pn = "docusaurus";
        }
        return this.toCanonicalFile(Paths.get(asciiDoctorBaseFolder, new String[0]).resolve(pn + ".adoc"));
    }

    public void createAdocFile() {
        Docusaurus2Adoc d2a = new Docusaurus2Adoc(this.project);
        d2a.run(this.getAdocFile());
    }

    public void createPdfFile() {
        this.pdfFile = new Adoc2Pdf().generatePdf(this.getAdoc2PdfConfig());
    }

    public void run() {
        this.createAdocFile();
        this.createPdfFile();
    }

    private Path toCanonicalFile(Path path, Path basePath) {
        if (path.isAbsolute()) {
            return this.toCanonicalFile(path);
        }
        if (basePath != null) {
            if (basePath.isAbsolute()) {
                return this.toCanonicalFile(basePath.resolve(path));
            }
            throw new IllegalArgumentException("base path must be absolute");
        }
        return this.toCanonicalFile(path);
    }

    private Path toCanonicalFile(Path path) {
        return path.toAbsolutePath().normalize();
    }

    public Adoc2PdfConfig getAdoc2PdfConfig() {
        Adoc2PdfConfig config = new Adoc2PdfConfig();
        NutsObjectElement asciiDoctorConfig = this.getAsciiDoctorConfig();
        config.setBin(asciiDoctorConfig.getSafeObject("pdf").getSafeObject("command").getSafeString("bin"));
        config.setArgs((String[])asciiDoctorConfig.getSafeObject("pdf").getSafeObject("command").getSafeArray("args").stream().map(x -> x.asString()).toArray(String[]::new));
        config.setWorkDir(this.toCanonicalFile(Paths.get(this.project.getDocusaurusBaseFolder(), new String[0])).toString());
        config.setBaseDir(this.toCanonicalFile(Paths.get(this.getAsciiDoctorBaseFolder(), new String[0])).toString());
        config.setInputAdoc(this.getAdocFile().toString());
        NutsElement output = asciiDoctorConfig.getSafeObject("pdf").getSafe("output");
        String pdfFile = this.project.getProjectName();
        if (output.isString()) {
            String s = output.asString().trim();
            if (!s.isEmpty()) {
                if (s.endsWith("/") || s.endsWith("\\")) {
                    s = s + this.project.getProjectName() + ".pdf";
                }
                pdfFile = s;
            }
        } else {
            pdfFile = this.project.getProjectName() + ".pdf";
        }
        pdfFile = this.toCanonicalFile(Paths.get(pdfFile, new String[0]), this.toCanonicalFile(Paths.get(this.project.getDocusaurusBaseFolder(), new String[0]))).toString();
        config.setOutputPdf(pdfFile);
        config.setPlaceHolderReplacer(varName -> {
            if (varName.equals("asciidoctor.baseDir")) {
                String r = this.getAsciiDoctorBaseFolder();
                if (r != null) {
                    r = Paths.get(r, new String[0]).normalize().toAbsolutePath().toString();
                }
                return r;
            }
            if (varName.equals("docusaurus.baseDir")) {
                String r = this.project.getDocusaurusBaseFolder();
                if (r != null) {
                    r = Paths.get(r, new String[0]).normalize().toAbsolutePath().toString();
                }
                return r;
            }
            if (varName.startsWith("asciidoctor.")) {
                return asciiDoctorConfig.get(varName.substring("asciidoctor.".length())).asString();
            }
            if (varName.startsWith("docusaurus.")) {
                return this.project.getConfig().get(varName.substring("docusaurus.".length())).asString();
            }
            return this.project.getConfig().get(varName).asString();
        });
        return config;
    }

    private String getAsciiDoctorBaseFolder() {
        String s = this.getAsciiDoctorConfig().get("path").asString();
        if (!new File(s).isAbsolute()) {
            s = this.project.getDocusaurusBaseFolder() + "/" + s;
        }
        return s;
    }

    private NutsObjectElement getAsciiDoctorConfig() {
        return this.project.getConfig().getSafeObject("customFields").getSafeObject("asciidoctor");
    }
}

