/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.MdBody;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.MdText;
import net.thevpc.nuts.lib.md.MdTitle;
import net.thevpc.nuts.lib.md.asciidoctor.AsciiDoctorWriter;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFile;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFileOrFolder;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFolder;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusPathFile;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusProject;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusTreeTransform;
import net.thevpc.nuts.toolbox.docusaurus.LenientWriter;

public class Docusaurus2Adoc {
    protected String[] headers;
    protected String projectName;
    protected String projectTitle;
    protected DocusaurusFolder rootFolder;
    protected NutsSession session;

    public Docusaurus2Adoc(DocusaurusProject project) {
        NutsObjectElement asciidoctorConfig = project.getConfig().getSafeObject("customFields").getSafeObject("asciidoctor");
        if (asciidoctorConfig == null) {
            throw new IllegalArgumentException("missing customFields.asciidoctor in docusaurus.config.js file");
        }
        NutsArrayElement headersJson = asciidoctorConfig.getSafeObject("pdf").getSafeArray("headers");
        ArrayList<String> headersList = new ArrayList<String>();
        for (NutsElement jsonItem : headersJson) {
            headersList.add(jsonItem.asString());
        }
        this.projectName = project.getProjectName();
        this.projectTitle = project.getTitle();
        this.headers = headersList.toArray(new String[0]);
        this.rootFolder = project.getSidebarsDocsFolder();
        this.session = project.getSession();
    }

    public Docusaurus2Adoc(File project, NutsSession session) {
        this(new DocusaurusProject(project.getPath(), null, session));
    }

    public String runToString() {
        StringWriter w = new StringWriter();
        this.run(w);
        return w.toString();
    }

    public void run(Path file) {
        try (PrintStream out = new PrintStream(Files.newOutputStream(file, new OpenOption[0]));){
            this.run(new LenientWriter(new PrintWriter(out, true), file.toString()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void run(PrintStream out) {
        PrintWriter w = null;
        try {
            w = new PrintWriter(out, true);
            this.run(w);
        }
        finally {
            if (w != null) {
                w.flush();
            }
        }
    }

    public void run(Writer out) {
        this.run(new LenientWriter(out, null));
    }

    protected String resolvePathParent(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().isEmpty()) {
            return null;
        }
        return Paths.get(s, new String[0]).getParent().toString();
    }

    protected void run(DocusaurusFileOrFolder part, LenientWriter out, AsciiDoctorWriter asciiDoctorWriter, int minDepth) {
        String toPath = this.resolvePathParent(out.path);
        if (part instanceof DocusaurusFile) {
            MdElement tree2;
            MdElement tree;
            DocusaurusFile item = (DocusaurusFile)part;
            String fromPath = null;
            if (item instanceof DocusaurusPathFile) {
                fromPath = this.resolvePathParent(((DocusaurusPathFile)item).getPath().toString());
            }
            if ((tree = item.getContent(this.session)) != null && (tree2 = new DocusaurusTreeTransform(this.session, minDepth + 1, fromPath, toPath).transformDocument(tree)) != null) {
                out.println();
                asciiDoctorWriter.write((MdElement)new MdBody(new MdElement[]{new MdTitle("#", (MdElement)MdText.phrase((String)item.getTitle()), minDepth, new MdElement[0]), tree2}));
            }
        } else if (part instanceof DocusaurusFolder) {
            MdElement tree;
            DocusaurusFolder folder = (DocusaurusFolder)part;
            out.println();
            out.println("");
            MdElement tree2 = tree = folder.getContent(this.session);
            if (tree != null) {
                String p = folder.getPath();
                tree2 = new DocusaurusTreeTransform(this.session, minDepth, p, toPath).transformDocument(tree);
            }
            ArrayList<Object> b = new ArrayList<Object>();
            if (tree2 == null || !this.startsWithTitle(tree2, minDepth)) {
                b.add(new MdTitle("#", (MdElement)MdText.phrase((String)part.getTitle()), minDepth, new MdElement[0]));
            }
            if (tree2 != null) {
                b.add(tree2);
            }
            if (!b.isEmpty()) {
                asciiDoctorWriter.write((MdElement)new MdBody(b.toArray(new MdElement[0])));
            }
            out.println("");
            for (DocusaurusFileOrFolder child : folder.getChildren()) {
                this.run(child, out, asciiDoctorWriter, minDepth + 1);
            }
        }
    }

    private boolean startsWithTitle(MdElement tree, int minDepth) {
        if (tree.isTitle()) {
            return tree.asTitle().type().depth() <= minDepth;
        }
        if (tree.isBody()) {
            for (MdElement ee : tree.asBody().getChildren()) {
                if (this.startsWithTitle(ee, minDepth)) {
                    return true;
                }
                if (ee.isText()) {
                    String text = ee.asText().getText();
                    if (text.trim().isEmpty()) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(LenientWriter out) {
        try {
            try {
                AsciiDoctorWriter asciiDoctorWriter = new AsciiDoctorWriter(out.writer);
                this.writeHeader(out);
                for (DocusaurusFileOrFolder docusaurusFileOrFolder : this.rootFolder.getChildren()) {
                    this.run(docusaurusFileOrFolder, out, asciiDoctorWriter, 2);
                }
            }
            finally {
                out.writer.flush();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void writeHeader(LenientWriter out) throws IOException {
        out.println("= " + this.projectTitle);
        for (String jsonItem : this.headers) {
            out.println(jsonItem);
        }
        out.println();
    }
}

