/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import net.thevpc.commons.docusaurus.DocusaurusCtrl;
import net.thevpc.commons.md.docusaurus.DocusaurusProject;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsConfirmationMode;

public class NDocusaurusMain
extends NutsApplication {
    public static void main(String[] args) {
        NDocusaurusMain.main(NDocusaurusMain.class, (String[])args);
    }

    public void run(final NutsApplicationContext appContext) {
        appContext.processCommandLine(new NutsCommandLineProcessor(){
            boolean start;
            boolean build;
            String workdir = null;
            boolean buildPdf = false;

            public boolean nextOption(NutsArgument option, NutsCommandLine cmdLine) {
                switch (option.getStringKey()) {
                    case "-d": 
                    case "--dir": {
                        if (this.workdir == null) {
                            this.workdir = cmdLine.nextString(new String[0]).getStringValue();
                            break;
                        }
                        cmdLine.unexpectedArgument();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return false;
            }

            public boolean nextNonOption(NutsArgument nonOption, NutsCommandLine cmdLine) {
                switch (nonOption.getString()) {
                    case "start": {
                        this.start = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "build": {
                        this.build = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "pdf": {
                        this.buildPdf = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                }
                return false;
            }

            public void prepare(NutsCommandLine commandline) {
                if (!(this.start || this.build || this.buildPdf)) {
                    commandline.required("missing command. try ndocusaurus pdf | start | build");
                }
            }

            public void exec() {
                if (this.workdir == null) {
                    this.workdir = ".";
                }
                DocusaurusProject docusaurusProject = new DocusaurusProject(this.workdir);
                new DocusaurusCtrl(docusaurusProject).setBuildWebSite(this.build).setStartWebSite(this.start).setBuildPdf(this.buildPdf).setAutoInstallNutsPackages(appContext.getWorkspace().config().options().getConfirm() == NutsConfirmationMode.YES).run();
            }
        });
    }
}

