package net.thevpc.nuts.toolbox.docusaurus;

import net.thevpc.nuts.*;
import net.thevpc.commons.md.docusaurus.DocusaurusProject;
import net.thevpc.commons.docusaurus.DocusaurusCtrl;

public class NDocusaurusMain extends NutsApplication {

    public static void main(String[] args) {
        main(NDocusaurusMain.class, args);
    }

    @Override
    public void run(NutsApplicationContext appContext) {
        appContext.processCommandLine(new NutsCommandLineProcessor() {
            boolean start;
            boolean build;
            String workdir = null;
            boolean buildPdf=false;

            @Override
            public boolean nextOption(NutsArgument option, NutsCommandLine cmdLine) {
                switch (option.getStringKey()) {
                    case "-d":
                    case "--dir": {
                        if (workdir == null) {
                            workdir = cmdLine.nextString().getStringValue();
                        } else {
                            cmdLine.unexpectedArgument();
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public boolean nextNonOption(NutsArgument nonOption, NutsCommandLine cmdLine) {
                switch (nonOption.getString()) {
                    case "start": {
                        start = cmdLine.nextBoolean().getBooleanValue();
                        return true;
                    }
                    case "build": {
                        build = cmdLine.nextBoolean().getBooleanValue();
                        return true;
                    }
                    case "pdf": {
                        buildPdf = cmdLine.nextBoolean().getBooleanValue();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void prepare(NutsCommandLine commandline) {
                if(!start && !build && !buildPdf){
                    commandline.required("missing command. try ndocusaurus pdf | start | build");
                }
            }

            @Override
            public void exec() {
                if (workdir == null) {
                    workdir = ".";
                }
                DocusaurusProject docusaurusProject = new DocusaurusProject(workdir);
                new DocusaurusCtrl(docusaurusProject)
                        .setBuildWebSite(build)
                        .setStartWebSite(start)
                        .setBuildPdf(buildPdf)
                        .setAutoInstallNutsPackages(appContext.getWorkspace().config().options().getConfirm()== NutsConfirmationMode.YES)
                        .run();
            }
        });
    }

}
