/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.java;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.JavadocComment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.toolbox.ndoc.doc.JDClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDConstructorDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDFieldDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDMethodDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPConstructorDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPFieldDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPMethodDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPRootDoc;

public class JPClassDoc
implements JDClassDoc {
    private JPRootDoc root;
    private String packageName;
    private ClassOrInterfaceDeclaration declaration;
    private List<JDMethodDoc> methods = new ArrayList<JDMethodDoc>();
    private List<JDConstructorDoc> constructors = new ArrayList<JDConstructorDoc>();
    private List<JDFieldDoc> fields = new ArrayList<JDFieldDoc>();

    public JPClassDoc(JPRootDoc root, ClassOrInterfaceDeclaration declaration, String packageName) {
        this.root = root;
        this.declaration = declaration;
        this.packageName = packageName;
        for (BodyDeclaration member : declaration.getMembers()) {
            if (member instanceof MethodDeclaration) {
                this.methods.add(new JPMethodDoc((MethodDeclaration)member, this));
            }
            if (member instanceof ConstructorDeclaration) {
                this.constructors.add(new JPConstructorDoc((ConstructorDeclaration)member, this));
            }
            if (!(member instanceof FieldDeclaration)) continue;
            FieldDeclaration vv = (FieldDeclaration)member;
            for (VariableDeclarator variable : vv.getVariables()) {
                this.fields.add(new JPFieldDoc(vv, variable, this));
            }
        }
    }

    @Override
    public JDFieldDoc[] fields() {
        return this.fields.toArray(new JDFieldDoc[0]);
    }

    @Override
    public JDConstructorDoc[] constructors() {
        return this.constructors.toArray(new JDConstructorDoc[0]);
    }

    @Override
    public JDMethodDoc[] methods() {
        return this.methods.toArray(new JDMethodDoc[0]);
    }

    @Override
    public String name() {
        return this.declaration.getName().asString();
    }

    @Override
    public String modifiers() {
        return Arrays.stream(this.declaration.getModifiers().toArray()).map(x -> x.toString()).collect(Collectors.joining(" "));
    }

    @Override
    public String qualifiedName() {
        if (this.packageName != null) {
            return this.packageName + "." + this.name();
        }
        return this.name();
    }

    @Override
    public JDDoc comments() {
        if (this.declaration.getComment().isPresent() && this.declaration.getComment().get() instanceof JavadocComment) {
            JavadocComment jc = (JavadocComment)this.declaration.getComment().get();
            return new JPDoc(StaticJavaParser.parseJavadoc((String)jc.getContent()));
        }
        return null;
    }

    @Override
    public boolean isClass() {
        return !this.isInterface() && !this.isEnum() && !this.isRecord() && !this.isAnnotation();
    }

    @Override
    public boolean isInterface() {
        return this.declaration.isInterface();
    }

    @Override
    public boolean isAnnotation() {
        return this.declaration.isAnnotationDeclaration();
    }

    @Override
    public boolean isEnum() {
        return this.declaration.isEnumDeclaration();
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    public JPRootDoc getRoot() {
        return this.root;
    }
}

