/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.lib.md.MdDocument;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.MdFactory;
import net.thevpc.nuts.lib.md.MdWriter;
import net.thevpc.nuts.toolbox.ndoc.doc.JDClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDConstructorDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDExecutableMemberDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDFieldDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDMethodDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDParamTag;
import net.thevpc.nuts.toolbox.ndoc.doc.JDParameter;
import net.thevpc.nuts.toolbox.ndoc.doc.JDType;
import net.thevpc.nuts.toolbox.ndoc.doc.MdDocletConfig;
import net.thevpc.nuts.toolbox.ndoc.doc.PropertyDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.ToClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPRootDoc;

public class MdDoclet {
    private static String _GLASSES_ICON = "\ud83d\udc53";
    private static String _BEETLE_ICON = "\ud83d\udc1e";
    private static String _CAFE_ICON = "\u2615";
    private static String _DRUM_ICON = "\ud83e\udd41";
    private static String _PENSIL_ICON = "\u270f";
    private static String _PENSIL2_ICON = "\ud83d\udd8a";
    private static String _CONTROLS_ICON = "\ud83c\udf9b";
    private static String _ICECUBE_ICON = "\u2744";
    private static String _PAGE_ICON = "\ud83d\udcc4";
    private static String _MEMO_ICON = "\ud83d\udcdd";
    private static String _LOUDSPEAKER_ICON = "\ud83d\udce2";
    private static String BUG_ICON = _BEETLE_ICON;
    private static String STATIC_ICON = _LOUDSPEAKER_ICON;
    private static String READONLY_ICON = _PAGE_ICON;
    private static String READWRITE_ICON = _MEMO_ICON;
    private static String WRITEONLY_ICON = _PENSIL_ICON;
    private static String CLASS_ICON = _CAFE_ICON;
    private static String CONSTRUCTOR_ICON = "\ud83e\ude84";
    private static String METHOD_ICON = "\u2699";
    private static String FIELD_ICON = "\ud83d\uddd2";
    private static String PROPERTY_ICON = _CONTROLS_ICON;
    private static String STATIC_PROPERTY_ICON = STATIC_ICON + PROPERTY_ICON;
    private static String CONST_ICON = STATIC_ICON + _ICECUBE_ICON;
    private static String STATIC_FIELD_ICON = STATIC_ICON + FIELD_ICON;
    private static String STATIC_METHOD_ICON = STATIC_ICON + METHOD_ICON;
    private static String READ_ICON = _GLASSES_ICON;
    private static String WRITE_ICON = _PENSIL_ICON;

    public static String getCategory(JDClassDoc c) {
        String t;
        JDDoc jd = c.comments();
        if (jd != null && (t = jd.getTag("category")) != null && !(t = t.trim()).isEmpty()) {
            return t;
        }
        return "Other";
    }

    static MdElement printClass(JDClassDoc cls) {
        ToClassDoc tcd = new ToClassDoc(cls);
        ArrayList<MdElement> seq = new ArrayList<MdElement>();
        seq.add(MdFactory.title((int)2, (String)(CLASS_ICON + " " + tcd.getCls().name())));
        String classType = tcd.getCls().isClass() ? "class" : (tcd.getCls().isAnnotation() ? "@interface" : (tcd.getCls().isEnum() ? "enum" : (tcd.getCls().isRecord() ? "record" : "class")));
        seq.add(MdFactory.codeBacktick3((String)"java", (String)(tcd.getCls().modifiers() + " " + classType + " " + tcd.getCls().qualifiedName())));
        if (tcd.getCls().comments() != null) {
            seq.add(tcd.getCls().comments().getDescription());
        }
        if (tcd.getConsts().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(CONST_ICON + " Constant Fields")));
            seq.add(MdDoclet.printFields(tcd.getConsts()));
        }
        if (tcd.getStaticFields().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(STATIC_FIELD_ICON + " Static Fields")));
            MdDoclet.printFields(tcd.getStaticFields());
        }
        if (tcd.getStaticProperties().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(STATIC_PROPERTY_ICON + " Static Properties")));
            seq.add(MdDoclet.printProperties(tcd.getStaticProperties()));
        }
        if (tcd.getStaticMethods().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(STATIC_METHOD_ICON + " Static Methods")));
            seq.add(MdDoclet.printMembers(tcd.getStaticMethods()));
        }
        if (tcd.getInstanceFields().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(FIELD_ICON + " Instance Fields")));
            seq.add(MdDoclet.printFields(tcd.getInstanceFields()));
        }
        if (tcd.getConstructors().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(CONSTRUCTOR_ICON + " Constructors")));
            seq.add(MdDoclet.printMembers(tcd.getConstructors()));
        }
        if (tcd.getInstanceProperties().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(PROPERTY_ICON + " Instance Properties")));
            seq.add(MdDoclet.printProperties(tcd.getInstanceProperties()));
        }
        if (tcd.getInstanceMethods().length > 0) {
            seq.add(MdFactory.title((int)3, (String)(METHOD_ICON + " Instance Methods")));
            seq.add(MdDoclet.printMembers(tcd.getInstanceMethods()));
        }
        return MdFactory.seq(seq);
    }

    static MdElement printFields(JDFieldDoc[] mems) {
        Arrays.sort(mems, new Comparator<JDFieldDoc>(){

            @Override
            public int compare(JDFieldDoc o1, JDFieldDoc o2) {
                return o1.qualifiedName().compareTo(o2.qualifiedName());
            }
        });
        ArrayList<MdElement> ss = new ArrayList<MdElement>();
        for (int i = 0; i < mems.length; ++i) {
            JDFieldDoc mem = mems[i];
            ss.add(MdDoclet.printField(mem));
        }
        return MdFactory.seq(ss);
    }

    static MdElement printProperties(PropertyDoc[] mems) {
        ArrayList<MdElement> ss = new ArrayList<MdElement>();
        for (int i = 0; i < mems.length; ++i) {
            PropertyDoc mem = mems[i];
            ss.add(MdDoclet.printProperty(mem));
        }
        return MdFactory.seq(ss);
    }

    static MdElement printMembers(JDExecutableMemberDoc[] mems) {
        Arrays.sort(mems, new Comparator<JDExecutableMemberDoc>(){

            @Override
            public int compare(JDExecutableMemberDoc o1, JDExecutableMemberDoc o2) {
                return o1.qualifiedName().compareTo(o2.qualifiedName());
            }
        });
        ArrayList<MdElement> seq = new ArrayList<MdElement>();
        for (int i = 0; i < mems.length; ++i) {
            JDExecutableMemberDoc mem = mems[i];
            seq.add(MdDoclet.printMember(mem));
        }
        return MdFactory.seq(seq);
    }

    static MdElement printMember(JDExecutableMemberDoc mem) {
        JDParameter[] params;
        JDMethodDoc md;
        String icon = null;
        icon = mem instanceof JDConstructorDoc ? CONSTRUCTOR_ICON : ((md = (JDMethodDoc)mem).isStatic() ? STATIC_METHOD_ICON : METHOD_ICON);
        JDType returnType = null;
        if (mem instanceof JDMethodDoc) {
            JDMethodDoc dd = (JDMethodDoc)mem;
            returnType = dd.returnType();
        }
        ArrayList<MdElement> seq = new ArrayList<MdElement>();
        seq.add(MdFactory.title((int)4, (String)(icon + " " + MdDoclet.sig(mem))));
        if (mem.commentText() != null) {
            seq.add(mem.commentText().getDescription());
        }
        seq.add(MdFactory.br());
        seq.add(MdFactory.codeBacktick3((String)"java", (String)MdDoclet.sig(mem, true, true)));
        for (JDParameter param : params = mem.parameters()) {
            seq.add(MdFactory.ul((int)1, (MdElement)MdFactory.seqInline((MdElement[])new MdElement[]{MdFactory.bold((MdElement)MdFactory.text((String)(MdDoclet.stype(param.type()) + " " + param.name()))), MdFactory.text((String)(" : " + (param.getJavadocContent() == null ? "" : param.getJavadocContent())))})));
        }
        return MdFactory.seq(seq);
    }

    private static String resolveComment(String paramName, JDParamTag[] tags) {
        for (JDParamTag tag : tags) {
            if (!tag.parameterName().equals(paramName)) continue;
            return tag.parameterComment();
        }
        return "";
    }

    static MdElement printField(JDFieldDoc mem) {
        String e = mem.constantValueExpression();
        String icon = FIELD_ICON;
        if (mem.isStatic()) {
            icon = mem.isFinal() ? CONST_ICON : STATIC_FIELD_ICON;
        }
        return MdFactory.seq((MdElement[])new MdElement[]{MdFactory.title((int)4, (String)(icon + " " + mem.name())), MdFactory.codeBacktick3((String)"java", (String)(mem.modifiers() + " " + MdDoclet.stype(mem.type()) + " " + mem.name() + (mem.constantValueExpression() == null ? "" : " = " + mem.constantValueExpression())))});
    }

    static MdElement printProperty(PropertyDoc mem) {
        String icon = PROPERTY_ICON;
        if (mem.isStatic()) {
            icon = STATIC_PROPERTY_ICON;
        }
        if (mem.isRW()) {
            icon = READWRITE_ICON + icon;
        } else if (mem.isRO()) {
            icon = READONLY_ICON + icon;
        } else if (mem.isWO()) {
            icon = WRITEONLY_ICON + icon;
        }
        ArrayList<MdElement> seq = new ArrayList<MdElement>();
        seq.add(MdFactory.title((int)4, (String)(icon + " " + mem.name)));
        if (mem.commentText() != null) {
            seq.add(mem.commentText().getDescription());
        }
        StringBuilder code = new StringBuilder();
        if (mem.isRW()) {
            code.append("[read-write] " + MdDoclet.stype(mem.type()) + " " + mem.setter.modifiers() + " " + mem.name).append("\n");
            if (mem.field != null) {
                code.append(mem.field.modifiers() + " " + MdDoclet.stype(mem.field.type()) + " " + mem.field.name() + (mem.field.constantValueExpression() == null ? "" : " = " + mem.field.constantValueExpression())).append("\n");
            }
            if (mem.getter != null) {
                code.append(mem.getter.modifiers() + " " + MdDoclet.sig2(mem.getter)).append("\n");
            }
            if (mem.setter != null) {
                code.append(mem.setter.modifiers() + " " + MdDoclet.sig2(mem.setter)).append("\n");
            }
        } else if (mem.isWO()) {
            code.append("[write-only] " + MdDoclet.stype(mem.type()) + " " + mem.setter.modifiers() + " " + mem.name).append("\n");
            if (mem.field != null) {
                code.append(mem.field.modifiers() + " " + MdDoclet.stype(mem.field.type()) + " " + mem.field.name() + (mem.field.constantValueExpression() == null ? "" : " = " + mem.field.constantValueExpression())).append("\n");
            }
            if (mem.getter != null) {
                code.append(mem.getter.modifiers() + " " + MdDoclet.sig2(mem.getter)).append("\n");
            }
            if (mem.setter != null) {
                code.append(mem.setter.modifiers() + " " + MdDoclet.sig2(mem.setter)).append("\n");
            }
        } else if (mem.isRO()) {
            code.append("[read-only] " + mem.getter.modifiers() + " " + MdDoclet.stype(mem.type()) + " " + mem.name).append("\n");
            if (mem.field != null) {
                code.append(mem.field.modifiers() + " " + MdDoclet.stype(mem.field.type()) + " " + mem.field.name() + (mem.field.constantValueExpression() == null ? "" : " = " + mem.field.constantValueExpression())).append("\n");
            }
            if (mem.getter != null) {
                code.append(mem.getter.modifiers() + " " + MdDoclet.sig2(mem.getter)).append("\n");
            }
            if (mem.setter != null) {
                code.append(mem.setter.modifiers() + " " + MdDoclet.sig2(mem.setter)).append("\n");
            }
        } else {
            throw new IllegalArgumentException("Should never happen");
        }
        seq.add(MdFactory.codeBacktick3((String)"java", (String)code.toString()));
        return MdFactory.seq(seq);
    }

    static String stype(JDType mem) {
        if (mem == null) {
            return "?";
        }
        if (mem.isPrimitive()) {
            return mem.toString();
        }
        String tn = mem.toString();
        if (tn.indexOf(46) > 0 && tn.indexOf(60) < 0) {
            return MdDoclet.escape(tn.substring(tn.lastIndexOf(46) + 1));
        }
        return MdDoclet.escape(mem.toString());
    }

    static String sig2(JDExecutableMemberDoc mem) {
        String s = MdDoclet.sig(mem);
        if (mem instanceof JDMethodDoc) {
            JDMethodDoc md = (JDMethodDoc)mem;
            if (md.returnType() != null) {
                return MdDoclet.stype(md.returnType()) + " " + s;
            }
            return MdDoclet.stype(md.returnType()) + " " + s;
        }
        return s;
    }

    static String sig(JDExecutableMemberDoc mem) {
        StringBuilder sb = new StringBuilder();
        sb.append(mem.name());
        sb.append("(");
        for (int i = 0; i < mem.parameters().length; ++i) {
            JDParameter parameter = mem.parameters()[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(parameter.name());
        }
        sb.append(")");
        return sb.toString();
    }

    static String sig(JDExecutableMemberDoc mem, boolean includeReturn, boolean includeTypes) {
        JDMethodDoc md;
        StringBuilder sb = new StringBuilder();
        if (includeReturn && mem instanceof JDMethodDoc && (md = (JDMethodDoc)mem).returnType() != null) {
            sb.append(MdDoclet.stype(md.returnType()));
            sb.append(" ");
        }
        sb.append(mem.name());
        sb.append("(");
        for (int i = 0; i < mem.parameters().length; ++i) {
            JDParameter parameter = mem.parameters()[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (includeTypes) {
                sb.append(MdDoclet.stype(parameter.type()));
                sb.append(" ");
            }
            sb.append(parameter.name());
        }
        sb.append(")");
        return sb.toString();
    }

    static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '\'': 
                case '<': 
                case '>': 
                case '@': 
                case '\\': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public boolean start(MdDocletConfig config) {
        JPRootDoc root = new JPRootDoc();
        String[] packages = config.getPackages();
        Predicate<String> packageFilter = packages.length == 0 ? x -> true : x -> {
            int n = 0;
            String[] stringArray = packages;
            int n2 = stringArray.length;
            if (n < n2) {
                String p = stringArray[n];
                if (p.equals("*")) {
                    return true;
                }
                if (p.equals(".*")) {
                    String sp = p.substring(0, p.length() - 2);
                    return x.equals(sp) || x.startsWith(sp + ".");
                }
                if (p.equals(".**")) {
                    String sp = p.substring(0, p.length() - 3);
                    return x.equals(sp) || x.startsWith(sp + ".");
                }
                return x.equals(p);
            }
            return false;
        };
        for (String s : config.getSources()) {
            root.parseSrcFolder(Paths.get(s, new String[0]), packageFilter);
        }
        JDClassDoc[] classes = root.classes();
        Arrays.sort(classes, new Comparator<JDClassDoc>(){

            @Override
            public int compare(JDClassDoc o1, JDClassDoc o2) {
                return o1.qualifiedName().compareTo(o2.qualifiedName());
            }
        });
        HashMap<String, List<JDClassDoc>> categories = new HashMap<String, List<JDClassDoc>>();
        for (int i = 0; i < classes.length; ++i) {
            String c = MdDoclet.getCategory(classes[i]);
            List<JDClassDoc> li = categories.computeIfAbsent(c, new Function<String, List<JDClassDoc>>(){

                @Override
                public List<JDClassDoc> apply(String t) {
                    return new ArrayList<JDClassDoc>();
                }
            });
            li.add(classes[i]);
        }
        for (Map.Entry entry : categories.entrySet()) {
            String name = (String)entry.getKey();
            String id = "javadoc_" + name.replace(' ', '_');
            File file = new File(config.getTarget(), (String)entry.getKey() + ".md");
            try {
                System.out.println("generating " + file.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            ArrayList<MdElement> doc = new ArrayList<MdElement>();
            for (JDClassDoc classDoc : (List)entry.getValue()) {
                doc.add(MdDoclet.printClass(classDoc));
            }
            try {
                MdWriter out = MdFactory.createWriter((String)config.getBackend(), (Writer)new FileWriter(file));
                Throwable throwable = null;
                try {
                    out.write(new MdDocument((Object)id, name, null, null, null, null, MdFactory.seq(doc)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return true;
    }
}

