/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.util;

import net.thevpc.nuts.toolbox.ndoc.doc.JDDocElement;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDocElementList;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDocElementString;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDocElementXml;

public class JDDocElementUtils {
    public static JDDocElement[] toList(JDDocElement e) {
        if (e instanceof JDDocElementList) {
            return ((JDDocElementList)e).values();
        }
        return new JDDocElement[]{e};
    }

    public static boolean isXmlTag(JDDocElement e, String tag) {
        if ((e = JDDocElementUtils.unpack(e)) == null) {
            return false;
        }
        if (e instanceof JDDocElementXml) {
            JDDocElementXml s = (JDDocElementXml)e;
            return s.getName().equals(tag);
        }
        return false;
    }

    public static boolean isBlank(JDDocElement e) {
        JDDocElementString s;
        if ((e = JDDocElementUtils.unpack(e)) == null) {
            return true;
        }
        if (e instanceof JDDocElementString && (s = (JDDocElementString)e).value().trim().isEmpty()) {
            return true;
        }
        if (e instanceof JDDocElementList) {
            JDDocElement[] t;
            JDDocElementList li = (JDDocElementList)e;
            for (JDDocElement jDDocElement : t = li.values()) {
                if (JDDocElementUtils.isBlank(jDDocElement)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static JDDocElement unpack(JDDocElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof JDDocElementList) {
            JDDocElementList li = (JDDocElementList)e;
            JDDocElement[] t = li.values();
            if (t.length == 0) {
                return null;
            }
            if (t.length == 1) {
                return JDDocElementUtils.unpack(t[0]);
            }
        }
        return e;
    }
}

