/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.util;

import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import com.github.javaparser.javadoc.description.JavadocSnippet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.lib.md.MdBold;
import net.thevpc.nuts.lib.md.MdBr;
import net.thevpc.nuts.lib.md.MdCode;
import net.thevpc.nuts.lib.md.MdCodeLink;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.MdFactory;
import net.thevpc.nuts.lib.md.MdHr;
import net.thevpc.nuts.lib.md.MdItalic;
import net.thevpc.nuts.lib.md.MdText;
import net.thevpc.nuts.lib.md.MdXml;
import net.thevpc.nuts.toolbox.ndoc.doc.util.CharReader;

public class DocReader {
    private static Set<String> unclosableTags = new HashSet<String>(Arrays.asList("p", "img", "br", "hr"));
    private List<Object> all = new ArrayList<Object>();

    public DocReader add(JavadocDescriptionElement e) {
        if (e instanceof JavadocSnippet) {
            this.all.add(new CharReader(e.toText()));
        } else if (e instanceof JavadocInlineTag) {
            JavadocInlineTag ee = (JavadocInlineTag)e;
            switch (ee.getType()) {
                case CODE: {
                    this.all.add(new MdCode(ee.getName(), ee.getContent(), true));
                    break;
                }
                case LINK: {
                    this.all.add(new MdCodeLink(ee.getName(), ee.getContent()));
                    break;
                }
                case LINKPLAIN: {
                    this.all.add(new MdCodeLink(ee.getName(), ee.getContent()));
                    break;
                }
                case LITERAL: {
                    this.all.add(new MdCode(ee.getName(), ee.getContent(), true));
                    break;
                }
                case VALUE: {
                    this.all.add(new MdCodeLink(ee.getName(), ee.getContent()));
                    break;
                }
                case SYSTEM_PROPERTY: {
                    this.all.add(new MdCode(ee.getName(), ee.getContent(), true));
                    break;
                }
                case DOC_ROOT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported");
                }
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public MdElement parse() {
        ArrayList<MdElement> result = new ArrayList<MdElement>();
        while (!this.isEmpty()) {
            MdElement a = this.readAny();
            if (a == null) {
                System.err.println("Unable to read");
                break;
            }
            result.add(a);
        }
        if (result.size() == 0) {
            return MdText.empty();
        }
        if (result.size() == 1) {
            return (MdElement)result.get(0);
        }
        return MdFactory.ofListOrEmpty((MdElement[])result.toArray(new MdElement[0]));
    }

    private MdElement readAny() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<MdElement> result = new ArrayList<MdElement>();
        while (!this.isEmpty()) {
            if (this.isCurrTag()) {
                result.add(this.currTag());
                this.all.remove(0);
                continue;
            }
            CharReader in = this.currText();
            if (in.isEmpty()) {
                this.all.remove(0);
                continue;
            }
            if (in.peek("</")) break;
            if (in.peek("<")) {
                String[] na = this.readHtmlTagStart();
                if (na[1].endsWith("/>") || this.isNoClosingTag(na[0])) {
                    result.add(this.prepareXml(new MdXml(MdXml.XmlTagType.OPEN, na[0], (Map)null, null)));
                    continue;
                }
                MdElement content = this.readAny();
                if (!this.isCurrText() || !this.currText().read("</" + na[0] + ">")) {
                    if (unclosableTags.contains(na[0])) continue;
                    System.err.println("missing </" + na[0] + ">");
                    continue;
                }
                result.add(this.prepareXml(new MdXml(MdXml.XmlTagType.OPEN, na[0], (Map)null, content)));
                continue;
            }
            result.add(this.readHtmlText());
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return (MdElement)result.get(0);
        }
        return MdFactory.ofListOrEmpty((MdElement[])result.toArray(new MdElement[0]));
    }

    protected MdElement prepareXml(MdXml xml) {
        switch (xml.getTag()) {
            case "p": {
                return MdFactory.seq((MdElement[])new MdElement[]{new MdBr(), xml.getContent(), new MdBr()});
            }
            case "strong": {
                return new MdBold(xml.getContent());
            }
            case "i": {
                return new MdItalic(xml.getContent());
            }
            case "pre": {
                return new MdCode("", xml.getContent().toString(), false);
            }
            case "code": {
                return new MdCode("", xml.getContent().toString(), false);
            }
            case "tt": {
                return new MdCode("", xml.getContent().toString(), true);
            }
            case "br": {
                return new MdBr();
            }
            case "hr": {
                return new MdHr();
            }
            case "ul": {
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(new MdBr());
                for (MdElement a : MdFactory.toArray((MdElement)xml.getContent())) {
                    if (MdFactory.isBlank((MdElement)a)) continue;
                    if (MdFactory.isXmlTag((MdElement)a, (String)"li")) {
                        items.add(((MdXml)a).getContent());
                        continue;
                    }
                    items.add(a);
                }
                return MdFactory.seq(items);
            }
            case "ol": {
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(new MdBr());
                for (MdElement a : MdFactory.toArray((MdElement)xml.getContent())) {
                    if (MdFactory.isBlank((MdElement)a)) continue;
                    if (MdFactory.isXmlTag((MdElement)a, (String)"li")) {
                        items.add(((MdXml)a).getContent());
                        continue;
                    }
                    items.add(a);
                }
                return MdFactory.seq(items);
            }
        }
        return xml;
    }

    private boolean isNoClosingTag(String s) {
        return s.equals("br") || s.equals("hr");
    }

    private MdElement readHtmlText() {
        CharReader in = this.currText();
        StringBuilder s = new StringBuilder();
        while (!in.isEmpty() && in.peek() != '<') {
            s.append(in.read());
        }
        return MdText.phrase((String)s.toString());
    }

    private String[] readHtmlTagStart() {
        StringBuilder sb = new StringBuilder();
        CharReader in = this.currText();
        char e = in.read();
        boolean acceptName = true;
        sb.append(e);
        StringBuilder n = new StringBuilder();
        while (!in.isEmpty()) {
            e = in.read();
            sb.append(e);
            if (e == '>') {
                return new String[]{n.toString(), sb.toString()};
            }
            if (e == ' ') {
                acceptName = false;
                continue;
            }
            if (!acceptName) continue;
            n.append(e);
        }
        return new String[]{n.toString(), sb.toString()};
    }

    public boolean isCurrTag() {
        return this.all.size() > 0 && this.all.get(0) instanceof MdElement;
    }

    public boolean isCurrText() {
        return this.all.size() > 0 && this.all.get(0) instanceof CharReader;
    }

    public CharReader currText() {
        return (CharReader)this.all.get(0);
    }

    public MdElement currTag() {
        return (MdElement)this.all.get(0);
    }
}

