/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.java;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.toolbox.ndoc.doc.JDClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDRootDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPClassDoc;

public class JPRootDoc
implements JDRootDoc {
    private Map<String, JDClassDoc> classes = new HashMap<String, JDClassDoc>();

    public void parseSrcFolder(Path path, Predicate<String> packageFilter) {
        try {
            if (Files.isRegularFile(path.resolve("pom.xml"), new LinkOption[0]) && Files.isDirectory(path.resolve("src/main/java"), new LinkOption[0])) {
                path = path.resolve("src/main/java");
            }
            Path path0 = path;
            Files.walk(path0, new FileVisitOption[0]).filter(x -> Files.isRegularFile(x, new LinkOption[0]) && x.getFileName().toString().endsWith(".java")).forEach(file -> {
                String pck = StreamSupport.stream(file.subpath(path0.getNameCount(), file.getNameCount()).spliterator(), false).map(Path::toString).collect(Collectors.joining("."));
                if (packageFilter == null || packageFilter.test(pck)) {
                    this.parseFile((Path)file);
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void parseFile(Path path) {
        try {
            new VoidVisitorAdapter<Object>(){
                PackageDeclaration p;

                public void visit(ClassOrInterfaceDeclaration n, Object arg) {
                    super.visit(n, arg);
                    JPRootDoc.this.add(new JPClassDoc(JPRootDoc.this, n, this.p.getName().asString()));
                }

                public void visit(PackageDeclaration p, Object arg) {
                    super.visit(p, arg);
                    this.p = p;
                }
            }.visit(StaticJavaParser.parse((Path)path), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JDClassDoc get(String qualifiedName) {
        return this.classes.get(qualifiedName);
    }

    public JPRootDoc add(JDClassDoc c) {
        this.classes.put(c.qualifiedName(), c);
        return this;
    }

    @Override
    public JDClassDoc[] classes() {
        return this.classes.values().toArray(new JDClassDoc[0]);
    }
}

