/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.java;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDMethodDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDParameter;
import net.thevpc.nuts.toolbox.ndoc.doc.JDType;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPParameter;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPType;

public class JPMethodDoc
implements JDMethodDoc {
    private MethodDeclaration declaration;
    private JPClassDoc cls;

    public JPMethodDoc(MethodDeclaration declaration, JPClassDoc cls) {
        this.declaration = declaration;
        this.cls = cls;
    }

    @Override
    public boolean isStatic() {
        for (Modifier modifier : this.declaration.getModifiers()) {
            if (modifier.getKeyword() != Modifier.Keyword.STATIC) continue;
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return this.declaration.getName().toString();
    }

    @Override
    public String qualifiedName() {
        return this.cls.qualifiedName() + "." + this.name();
    }

    @Override
    public String modifiers() {
        return Arrays.stream(this.declaration.getModifiers().toArray()).map(x -> x.toString()).collect(Collectors.joining(" "));
    }

    @Override
    public JDType returnType() {
        return new JPType(this.declaration.getType());
    }

    @Override
    public JDParameter[] parameters() {
        ArrayList<JPParameter> param = new ArrayList<JPParameter>();
        for (Parameter parameter : this.declaration.getParameters()) {
            String n = parameter.getName().toString();
            String javadocContent = null;
            Javadoc jd = this.declaration.getJavadoc().orElse(null);
            if (jd != null) {
                for (JavadocBlockTag blockTag : jd.getBlockTags()) {
                    if (blockTag.getType() != JavadocBlockTag.Type.PARAM || !blockTag.getName().orElse("").equals(n)) continue;
                    javadocContent = blockTag.getContent().toText();
                }
            }
            param.add(new JPParameter(parameter, javadocContent));
        }
        return param.toArray(new JDParameter[0]);
    }

    @Override
    public JDDoc commentText() {
        if (this.declaration.getComment().isPresent() && this.declaration.getComment().get() instanceof JavadocComment) {
            JavadocComment jc = (JavadocComment)this.declaration.getComment().get();
            return new JPDoc(StaticJavaParser.parseJavadoc((String)jc.getContent()));
        }
        return null;
    }
}

