/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc.java;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.Expression;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.toolbox.ndoc.doc.JDDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDFieldDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDType;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.java.JPType;

public class JPFieldDoc
implements JDFieldDoc {
    private FieldDeclaration fieldDeclaration;
    private VariableDeclarator variableDeclarator;
    private JPClassDoc cls;

    public JPFieldDoc(FieldDeclaration fieldDeclaration, VariableDeclarator variableDeclarator, JPClassDoc cls) {
        this.fieldDeclaration = fieldDeclaration;
        this.variableDeclarator = variableDeclarator;
        this.cls = cls;
    }

    @Override
    public boolean isStatic() {
        for (Modifier modifier : this.fieldDeclaration.getModifiers()) {
            if (modifier.getKeyword() != Modifier.Keyword.STATIC) continue;
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return this.variableDeclarator.getName().getIdentifier();
    }

    @Override
    public String qualifiedName() {
        return this.cls.qualifiedName() + "." + this.name();
    }

    @Override
    public JDType type() {
        return new JPType(this.variableDeclarator.getType());
    }

    @Override
    public String constantValueExpression() {
        Expression e = this.variableDeclarator.getInitializer().orElse(null);
        return e == null ? null : e.toString();
    }

    @Override
    public boolean isFinal() {
        for (Modifier modifier : this.fieldDeclaration.getModifiers()) {
            if (modifier.getKeyword() != Modifier.Keyword.FINAL) continue;
            return true;
        }
        return false;
    }

    @Override
    public String modifiers() {
        return Arrays.stream(this.fieldDeclaration.getModifiers().toArray()).map(x -> x.toString()).collect(Collectors.joining(" "));
    }

    @Override
    public JDDoc commentText() {
        if (this.fieldDeclaration.getComment().isPresent() && this.fieldDeclaration.getComment().get() instanceof JavadocComment) {
            JavadocComment jc = (JavadocComment)this.fieldDeclaration.getComment().get();
            return new JPDoc(StaticJavaParser.parseJavadoc((String)jc.getContent()));
        }
        return null;
    }
}

