/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndoc.doc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.toolbox.ndoc.doc.JDClassDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDConstructorDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDFieldDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDMethodDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.JDParameter;
import net.thevpc.nuts.toolbox.ndoc.doc.PropertyDoc;
import net.thevpc.nuts.toolbox.ndoc.doc.PropertyKind;

public class ToClassDoc {
    private JDClassDoc cls;
    private List<PropertyDoc> staticProperties = new ArrayList<PropertyDoc>();
    private List<PropertyDoc> instanceProperties = new ArrayList<PropertyDoc>();
    private List<JDFieldDoc> consts = new ArrayList<JDFieldDoc>();
    private List<JDFieldDoc> staticFields = new ArrayList<JDFieldDoc>();
    private List<JDFieldDoc> instanceFields = new ArrayList<JDFieldDoc>();
    private List<JDMethodDoc> staticMethods = new ArrayList<JDMethodDoc>();
    private List<JDMethodDoc> instanceMethods = new ArrayList<JDMethodDoc>();
    private List<JDConstructorDoc> constructors = new ArrayList<JDConstructorDoc>();

    public ToClassDoc(JDClassDoc cls) {
        this.cls = cls;
        for (JDFieldDoc field : cls.fields()) {
            if (field.isStatic() && field.isFinal()) {
                this.consts.add(field);
                continue;
            }
            if (field.isStatic()) {
                this.staticFields.add(field);
                continue;
            }
            this.instanceFields.add(field);
        }
        for (JDConstructorDoc constructor : cls.constructors()) {
            this.constructors.add(constructor);
        }
        block2: for (JDMethodDoc m : cls.methods()) {
            JDFieldDoc field;
            Iterator<Object> it;
            PropertyKind r = this.resolvePropertyKind(m);
            if (r == null) {
                if (m.isStatic()) {
                    this.staticMethods.add(m);
                    continue;
                }
                this.instanceMethods.add(m);
                continue;
            }
            PropertyDoc property0 = null;
            if (m.isStatic()) {
                for (PropertyDoc property : this.staticProperties) {
                    if (!property.name.equals(r.name)) continue;
                    property0 = property;
                    break;
                }
                if (property0 == null) {
                    property0 = new PropertyDoc();
                    property0.name = r.name;
                    this.staticProperties.add(property0);
                }
                if (r.kind.equals("set")) {
                    property0.setter = m;
                } else {
                    property0.getter = m;
                }
                it = this.staticFields.iterator();
                while (it.hasNext()) {
                    field = (JDFieldDoc)it.next();
                    if (!field.name().equals(r.name)) continue;
                    property0.field = field;
                    it.remove();
                    continue block2;
                }
                continue;
            }
            for (PropertyDoc property : this.instanceProperties) {
                if (!property.name.equals(r.name)) continue;
                property0 = property;
                break;
            }
            if (property0 == null) {
                property0 = new PropertyDoc();
                property0.name = r.name;
                this.instanceProperties.add(property0);
            }
            if (r.kind.equals("set")) {
                property0.setter = m;
            } else {
                property0.getter = m;
            }
            it = this.instanceFields.iterator();
            while (it.hasNext()) {
                field = (JDFieldDoc)it.next();
                if (!field.name().equals(r.name)) continue;
                property0.field = field;
                it.remove();
                continue block2;
            }
        }
        this.staticProperties.sort(new Comparator<PropertyDoc>(){

            @Override
            public int compare(PropertyDoc o1, PropertyDoc o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.instanceProperties.sort(new Comparator<PropertyDoc>(){

            @Override
            public int compare(PropertyDoc o1, PropertyDoc o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.consts.sort(new Comparator<JDFieldDoc>(){

            @Override
            public int compare(JDFieldDoc o1, JDFieldDoc o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.staticFields.sort(new Comparator<JDFieldDoc>(){

            @Override
            public int compare(JDFieldDoc o1, JDFieldDoc o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.instanceFields.sort(new Comparator<JDFieldDoc>(){

            @Override
            public int compare(JDFieldDoc o1, JDFieldDoc o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.staticMethods.sort(new Comparator<JDMethodDoc>(){

            @Override
            public int compare(JDMethodDoc o1, JDMethodDoc o2) {
                int t = o1.name().compareTo(o2.name());
                if (t != 0) {
                    return t;
                }
                t = o1.parameters().length - o2.parameters().length;
                if (t != 0) {
                    return t;
                }
                for (int i = 0; i < o1.parameters().length; ++i) {
                    t = o1.parameters()[i].name().compareTo(o2.parameters()[i].name());
                    if (t == 0) continue;
                    return t;
                }
                return t;
            }
        });
        this.instanceMethods.sort(new Comparator<JDMethodDoc>(){

            @Override
            public int compare(JDMethodDoc o1, JDMethodDoc o2) {
                int t = o1.name().compareTo(o2.name());
                if (t != 0) {
                    return t;
                }
                t = o1.parameters().length - o2.parameters().length;
                if (t != 0) {
                    return t;
                }
                for (int i = 0; i < o1.parameters().length; ++i) {
                    t = o1.parameters()[i].name().compareTo(o2.parameters()[i].name());
                    if (t == 0) continue;
                    return t;
                }
                return t;
            }
        });
        this.constructors.sort(new Comparator<JDConstructorDoc>(){

            @Override
            public int compare(JDConstructorDoc o1, JDConstructorDoc o2) {
                int t = o1.name().compareTo(o2.name());
                if (t != 0) {
                    return t;
                }
                t = o1.parameters().length - o2.parameters().length;
                if (t != 0) {
                    return t;
                }
                for (int i = 0; i < o1.parameters().length; ++i) {
                    t = o1.parameters()[i].name().compareTo(o2.parameters()[i].name());
                    if (t == 0) continue;
                    return t;
                }
                return t;
            }
        });
    }

    public PropertyDoc[] getStaticProperties() {
        return this.staticProperties.toArray(new PropertyDoc[0]);
    }

    public PropertyDoc[] getInstanceProperties() {
        return this.instanceProperties.toArray(new PropertyDoc[0]);
    }

    public JDFieldDoc[] getConsts() {
        return this.consts.toArray(new JDFieldDoc[0]);
    }

    public JDFieldDoc[] getStaticFields() {
        return this.staticFields.toArray(new JDFieldDoc[0]);
    }

    public JDFieldDoc[] getInstanceFields() {
        return this.instanceFields.toArray(new JDFieldDoc[0]);
    }

    public JDMethodDoc[] getStaticMethods() {
        return this.staticMethods.toArray(new JDMethodDoc[0]);
    }

    public JDMethodDoc[] getInstanceMethods() {
        return this.instanceMethods.toArray(new JDMethodDoc[0]);
    }

    public JDConstructorDoc[] getConstructors() {
        return this.constructors.toArray(new JDConstructorDoc[0]);
    }

    public PropertyKind resolvePropertyKind(JDMethodDoc n) {
        String a;
        JDParameter[] parameters = n.parameters();
        if (n.name().startsWith("get") && parameters.length == 0 && (a = n.name().substring(3)).length() > 0) {
            if (Character.isUpperCase(a.charAt(0))) {
                return new PropertyKind("get", Character.toLowerCase(a.charAt(0)) + a.substring(1));
            }
            return new PropertyKind("get", Character.toLowerCase(a.charAt(0)) + a.substring(1));
        }
        if (n.name().startsWith("is") && parameters.length == 0 && (a = n.name().substring(2)).length() > 0) {
            if (Character.isUpperCase(a.charAt(0))) {
                return new PropertyKind("get", Character.toLowerCase(a.charAt(0)) + a.substring(1));
            }
            return new PropertyKind("get", Character.toLowerCase(a.charAt(0)) + a.substring(1));
        }
        if (n.name().startsWith("set") && parameters.length == 1 && (a = n.name().substring(3)).length() > 0) {
            if (Character.isUpperCase(a.charAt(0))) {
                return new PropertyKind("set", Character.toLowerCase(a.charAt(0)) + a.substring(1));
            }
            return new PropertyKind("set", Character.toLowerCase(a.charAt(0)) + a.substring(1));
        }
        return null;
    }

    public JDClassDoc getCls() {
        return this.cls;
    }
}

