/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.toolbox.ndiff.jar.AbstractDiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItemCreateContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItemJavaClass;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffKey;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffStatus;
import net.thevpc.nuts.toolbox.ndiff.jar.util.DiffUtils;

public class DiffCommandJavaClass
extends AbstractDiffCommand {
    public static final DiffCommand INSTANCE = new DiffCommandJavaClass();

    protected DiffCommandJavaClass() {
        super("java-class");
    }

    @Override
    public int acceptInput(Object input) {
        File f;
        String n;
        if (input instanceof InputStream) {
            return 1;
        }
        if (input instanceof byte[]) {
            return 1;
        }
        if (input instanceof File && (n = (f = (File)input).getName().toLowerCase()).endsWith(".class")) {
            return 100;
        }
        return -1;
    }

    @Override
    public Object prepareSourceOrTarget(Object source) {
        if (source instanceof File) {
            try {
                return Files.readAllBytes(((File)source).toPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (source instanceof InputStream) {
            DiffUtils.allBytes((InputStream)source);
        }
        if (source instanceof byte[]) {
            return source;
        }
        throw new IllegalArgumentException("Unsupported Java class Input " + source);
    }

    @Override
    public boolean acceptDiffKey(DiffKey key) {
        switch (key.getKind()) {
            case "file": {
                return key.getName().endsWith(".class");
            }
        }
        return false;
    }

    @Override
    public Map<DiffKey, String> map(Object item, DiffEvalContext diffEvalContext) {
        return new HashMap<DiffKey, String>();
    }

    @Override
    public String hash(InputStream source) {
        return DiffUtils.hashStream(source);
    }

    @Override
    public DiffItem createContentDiffItem(DiffItemCreateContext context) {
        switch (context.getStatus()) {
            case ADDED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.ADDED, null, null);
            }
            case REMOVED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.REMOVED, null, null);
            }
            case CHANGED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.CHANGED, null, null);
            }
        }
        throw new UnsupportedOperationException();
    }
}

