/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.thevpc.nuts.toolbox.ndiff.jar.DefaultDiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffResult;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandJar;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandJavaClass;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandJavaManifest;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandJavaProperties;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandVar;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandZip;

public class DiffBuilder {
    private Object source;
    private Object target;
    private String type;
    private boolean verbose;
    private boolean defaultPathFilterEnabled = true;
    private Predicate<String> pathFilter;
    private List<DiffCommand> commands = new ArrayList<DiffCommand>();
    private Map<String, Object> userProperties = new HashMap<String, Object>();

    public DiffBuilder(Object source, Object target) {
        this.source = source;
        this.target = target;
        this.commands.add(DiffCommandJavaClass.INSTANCE);
        this.commands.add(DiffCommandJavaManifest.INSTANCE);
        this.commands.add(DiffCommandJavaProperties.INSTANCE);
        this.commands.add(DiffCommandJar.INSTANCE);
        this.commands.add(DiffCommandZip.INSTANCE);
        this.commands.add(DiffCommandVar.INSTANCE);
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public DiffBuilder setUserProperties(Map<String, Object> userProperties) {
        this.userProperties = new HashMap<String, Object>();
        if (userProperties != null) {
            for (Map.Entry<String, Object> e : userProperties.entrySet()) {
                if (e.getValue() == null) continue;
                this.userProperties.put(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public DiffBuilder userProperty(String key, Object value) {
        if (value != null) {
            this.userProperties.put(key, value);
        } else {
            this.userProperties.remove(key);
        }
        return this;
    }

    public DiffBuilder userProperties(Map<String, Object> userProperties) {
        return this.appendUserProperties(userProperties);
    }

    public DiffBuilder appendUserProperties(Map<String, Object> userProperties) {
        if (userProperties != null) {
            for (Map.Entry<String, Object> e : userProperties.entrySet()) {
                this.userProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public boolean isDefaultPathFilterEnabled() {
        return this.defaultPathFilterEnabled;
    }

    public DiffBuilder setDefaultPathFilterEnabled(boolean defaultPathFilterEnabled) {
        this.defaultPathFilterEnabled = defaultPathFilterEnabled;
        return this;
    }

    public DiffBuilder verbose() {
        return this.verbose(true);
    }

    public DiffBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public DiffBuilder as(String type) {
        this.type = type;
        return this;
    }

    public Predicate<String> getPathFilter() {
        return this.pathFilter;
    }

    public DiffBuilder setPathFilter(Predicate<String> pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffBuilder pathFilter(Predicate<String> pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public DiffResult eval() {
        DefaultDiffEvalContext c = new DefaultDiffEvalContext();
        c.setSource(this.source);
        c.setTarget(this.target);
        c.setSupportedCommands(this.commands);
        c.setVerbose(this.isVerbose());
        c.setUserProperties(this.getUserProperties());
        c.setPathFilter(this.getPathFilter());
        c.setDefaultPathFilterEnabled(this.isDefaultPathFilterEnabled());
        int best = 0;
        DiffCommand bestCommand = null;
        for (DiffCommand command : this.commands) {
            if (this.type != null && command.getId().equals(this.type)) {
                bestCommand = command;
                break;
            }
            int a = 0;
            int b = 0;
            a = command.acceptInput(this.source);
            if (a <= 0 || (b = command.acceptInput(this.target)) <= 0 || a <= best || b <= best) continue;
            bestCommand = command;
            best = Math.min(a, b);
        }
        if (bestCommand != null) {
            return bestCommand.eval(c);
        }
        throw new IllegalArgumentException("Unable to build diff command");
    }
}

