/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar;

import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffStatus;

public abstract class AbstractDiffItem
implements DiffItem {
    private final String name;
    private final String kind;
    private final DiffStatus status;
    private final String description;
    private final List<DiffItem> details;

    public AbstractDiffItem(String kind, String name, DiffStatus status, String description, List<DiffItem> details) {
        this.kind = kind;
        this.name = name;
        this.status = status;
        this.description = description;
        this.details = details == null ? Collections.EMPTY_LIST : details;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DiffStatus getStatus() {
        return this.status;
    }

    public String toString() {
        DiffStatus kind = this.getStatus();
        String c = kind == DiffStatus.ADDED ? "+ " : (kind == DiffStatus.REMOVED ? "- " : (kind == DiffStatus.CHANGED ? "~ " : "? "));
        return c + this.getKind() + " : " + this.getName() + (this.description == null ? "" : " (" + this.description + ")");
    }

    @Override
    public List<DiffItem> children() {
        return this.details;
    }
}

