/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.thevpc.nuts.toolbox.ndiff.jar.AbstractDiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItemCreateContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItemJavaClass;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffKey;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffStatus;
import net.thevpc.nuts.toolbox.ndiff.jar.util.DiffUtils;

public class DiffCommandZip
extends AbstractDiffCommand {
    public static final DiffCommandZip INSTANCE = new DiffCommandZip();

    protected DiffCommandZip() {
        super("zip");
    }

    protected DiffCommandZip(String id) {
        super(id);
    }

    @Override
    public int acceptInput(Object input) {
        if (input instanceof File) {
            File f = (File)input;
            String n = f.getName().toLowerCase();
            if (n.endsWith(".zip")) {
                return 100;
            }
            if (n.endsWith(".jar") || n.endsWith(".war") || n.endsWith(".ear")) {
                return 50;
            }
        }
        return -1;
    }

    @Override
    public Object prepareSourceOrTarget(Object source) {
        if (source instanceof File) {
            return new ZipSourceFile((File)source);
        }
        if (source instanceof ZipSource) {
            return source;
        }
        throw new IllegalArgumentException("Unsupported zip from " + source);
    }

    protected boolean acceptEntry(String entryName) {
        return true;
    }

    @Override
    public boolean acceptDiffKey(DiffKey key) {
        switch (key.getKind()) {
            case "file": {
                return key.getName().endsWith(".zip");
            }
        }
        return false;
    }

    @Override
    public Map<DiffKey, String> map(Object item, DiffEvalContext diffEvalContext) {
        HashMap<DiffKey, String> t = new HashMap<DiffKey, String>();
        if (item instanceof ZipSourceFile) {
            try {
                ZipFile zipFile = ((ZipSourceFile)item).getZfile();
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                Predicate<String> pathFilter = diffEvalContext.getPathFilter();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    if (entryName.endsWith("/") || pathFilter != null && !pathFilter.test(entryName) || diffEvalContext.isDefaultPathFilterEnabled() && !this.acceptEntry(entryName)) continue;
                    InputStream is = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        DiffCommand factory = this.resolveDiffItemFactory(new DiffKey(entryName, "file", 0), diffEvalContext);
                        String ss = factory.hash(is);
                        if (ss == null) continue;
                        t.put(new DiffKey(entryName, "file", 0), ss);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        throw new IllegalArgumentException("Unsupported source " + item);
        return t;
    }

    @Override
    public String hash(InputStream source) {
        return DiffUtils.hashStream(source);
    }

    @Override
    public DiffItem createContentDiffItem(DiffItemCreateContext context) {
        switch (context.getStatus()) {
            case ADDED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.ADDED, null, null);
            }
            case REMOVED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.REMOVED, null, null);
            }
            case CHANGED: {
                return new DiffItemJavaClass(context.getKey().getName(), DiffStatus.CHANGED, null, null);
            }
        }
        throw new UnsupportedOperationException();
    }

    public class ZipSourceFile
    implements ZipSource {
        private File file;
        private ZipFile zfile;

        public ZipSourceFile(File file) {
            this.file = file;
        }

        public ZipFile getZfile() {
            if (this.zfile == null) {
                try {
                    this.zfile = new ZipFile(this.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.zfile;
        }

        @Override
        public InputStream getInputStream(String name) {
            try {
                return this.getZfile().getInputStream(this.getZfile().getEntry(name));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.zfile != null) {
                this.zfile.close();
            }
        }
    }

    public static interface ZipSource
    extends AutoCloseable {
        public InputStream getInputStream(String var1);
    }
}

