/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.thevpc.nuts.toolbox.ndiff.jar.AbstractDiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DefaultDiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DefaultDiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItemCreateContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffKey;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffStatus;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandZip;
import net.thevpc.nuts.toolbox.ndiff.jar.util.DiffUtils;

public class DiffCommandJavaManifest
extends AbstractDiffCommand {
    public static final DiffCommandJavaManifest INSTANCE = new DiffCommandJavaManifest();

    protected DiffCommandJavaManifest() {
        super("java-manifest");
    }

    @Override
    public int acceptInput(Object input) {
        File f;
        String n;
        if (input instanceof Manifest) {
            return 100;
        }
        if (input instanceof InputStream) {
            return 1;
        }
        if (input instanceof byte[]) {
            return 1;
        }
        if (input instanceof File && (n = (f = (File)input).getName().toLowerCase()).endsWith(".mf")) {
            return 100;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Manifest prepareSourceOrTarget(Object source) {
        if (source instanceof File) {
            try (FileInputStream i = new FileInputStream((File)source);){
                Manifest manifest = new Manifest(i);
                return manifest;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (source instanceof Manifest) {
            return (Manifest)source;
        }
        if (source instanceof InputStream) {
            try {
                return new Manifest((InputStream)source);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (!(source instanceof byte[])) throw new IllegalArgumentException("Unsupported Manifest Input " + source);
        try {
            return new Manifest(new ByteArrayInputStream((byte[])source));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean acceptDiffKey(DiffKey key) {
        switch (key.getKind()) {
            case "file": {
                return DiffUtils.isFileName("MANIFEST.MF", key.getName());
            }
        }
        return false;
    }

    @Override
    public Map<DiffKey, String> map(Object item, DiffEvalContext diffEvalContext) {
        Manifest m = this.prepareSourceOrTarget(item);
        HashMap<DiffKey, String> s = new HashMap<DiffKey, String>();
        if (m != null) {
            for (Map.Entry<Object, Object> entry : m.getMainAttributes().entrySet()) {
                s.put(new DiffKey(entry.getKey().toString(), "var", 0), String.valueOf(entry.getValue()));
            }
            for (Map.Entry<Object, Object> entry : m.getEntries().entrySet()) {
                for (Map.Entry<Object, Object> e : ((Attributes)entry.getValue()).entrySet()) {
                    s.put(new DiffKey((String)entry.getKey() + "." + e.getKey().toString(), "var", 0), String.valueOf(e.getValue()));
                }
            }
        }
        return s;
    }

    @Override
    public String hash(InputStream source) {
        Manifest m = null;
        try {
            m = DiffUtils.prepareManifest(new Manifest(source));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.write(os);
            return DiffUtils.hashStream(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public DiffItem createContentDiffItem(DiffItemCreateContext context) {
        switch (context.getStatus()) {
            case ADDED: {
                return new DefaultDiffItem("java-manifest", context.getKey().getName(), DiffStatus.ADDED, null, null);
            }
            case REMOVED: {
                return new DefaultDiffItem("java-manifest", context.getKey().getName(), DiffStatus.REMOVED, null, null);
            }
            case CHANGED: {
                List<DiffItem> details = null;
                if (context.getEvalContext().isVerbose()) {
                    DiffCommandZip.ZipSource zsrc = (DiffCommandZip.ZipSource)context.getEvalContext().getSource();
                    DiffCommandZip.ZipSource ztgt = (DiffCommandZip.ZipSource)context.getEvalContext().getTarget();
                    try (InputStream i1 = zsrc.getInputStream(context.getKey().getName());
                         InputStream i2 = ztgt.getInputStream(context.getKey().getName());){
                        DefaultDiffEvalContext evalContext = new DefaultDiffEvalContext(context.getEvalContext());
                        evalContext.setSource(i1);
                        evalContext.setTarget(i2);
                        details = this.eval(evalContext).all();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return new DefaultDiffItem("java-manifest", context.getKey().getName(), DiffStatus.CHANGED, null, details);
            }
        }
        throw new UnsupportedOperationException();
    }
}

