/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar.commands;

import java.io.File;
import java.util.function.Predicate;
import net.thevpc.nuts.toolbox.ndiff.jar.commands.DiffCommandZip;

public class DiffCommandJar
extends DiffCommandZip {
    public static final DiffCommandJar INSTANCE = new DiffCommandJar();
    private static final Predicate<String> DEFAULT_PATH_FILTER_IMPL = x -> !x.equals(".netbeans_automatic_build");

    protected DiffCommandJar() {
        super("jar");
    }

    @Override
    protected boolean acceptEntry(String entryName) {
        return DEFAULT_PATH_FILTER_IMPL.test(entryName);
    }

    @Override
    public int acceptInput(Object input) {
        if (input instanceof File) {
            File f = (File)input;
            String n = f.getName().toLowerCase();
            if (n.endsWith(".zip")) {
                return 50;
            }
            if (n.endsWith(".jar") || n.endsWith(".war") || n.endsWith(".ear")) {
                return 100;
            }
        }
        return -1;
    }
}

