/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndiff.jar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffCommand;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffEvalContext;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffKey;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffResult;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffStatus;

public class AbstractDiffResult
implements DiffResult {
    private final DiffCommand diff;
    private final TreeMap<DiffKey, String> added;
    private final TreeMap<DiffKey, String> removed;
    private final TreeMap<DiffKey, String[]> changed;
    private DiffEvalContext diffEvalContext;

    public AbstractDiffResult(DiffCommand diff, DiffEvalContext diffEvalContext, TreeMap<DiffKey, String> added, TreeMap<DiffKey, String> removed, TreeMap<DiffKey, String[]> changed) {
        this.diff = diff;
        this.added = added;
        this.removed = removed;
        this.changed = changed;
        this.diffEvalContext = diffEvalContext;
    }

    public DiffEvalContext getDiffEvalContext() {
        return this.diffEvalContext;
    }

    public DiffCommand getDiff() {
        return this.diff;
    }

    public Iterator iterator() {
        return this.all().iterator();
    }

    @Override
    public boolean hasChanges() {
        return !this.added.isEmpty() || !this.removed.isEmpty() || !this.changed.isEmpty();
    }

    @Override
    public List<DiffItem> all() {
        ArrayList<DiffItem> a = new ArrayList<DiffItem>();
        for (Map.Entry<DiffKey, String> entry : this.removed.entrySet()) {
            a.add(this.diff.createChildItem(entry.getKey(), DiffStatus.REMOVED, entry.getValue(), null, this.diffEvalContext));
        }
        for (Map.Entry<DiffKey, String> entry : this.changed.entrySet()) {
            a.add(this.diff.createChildItem(entry.getKey(), DiffStatus.CHANGED, ((String[])entry.getValue())[0], ((String[])entry.getValue())[1], this.diffEvalContext));
        }
        for (Map.Entry<DiffKey, String> entry : this.added.entrySet()) {
            a.add(this.diff.createChildItem(entry.getKey(), DiffStatus.ADDED, null, entry.getValue(), this.diffEvalContext));
        }
        return a;
    }

    @Override
    public List<DiffItem> removed() {
        ArrayList<DiffItem> a = new ArrayList<DiffItem>();
        for (Map.Entry<DiffKey, String> n : this.removed.entrySet()) {
            a.add(this.diff.createChildItem(n.getKey(), DiffStatus.REMOVED, n.getValue(), null, this.diffEvalContext));
        }
        return a;
    }

    @Override
    public List<DiffItem> added() {
        ArrayList<DiffItem> a = new ArrayList<DiffItem>();
        for (Map.Entry<DiffKey, String> n : this.added.entrySet()) {
            a.add(this.diff.createChildItem(n.getKey(), DiffStatus.ADDED, null, n.getValue(), this.diffEvalContext));
        }
        return a;
    }

    @Override
    public List<DiffItem> changed() {
        ArrayList<DiffItem> a = new ArrayList<DiffItem>();
        for (Map.Entry<DiffKey, String[]> n : this.changed.entrySet()) {
            a.add(this.diff.createChildItem(n.getKey(), DiffStatus.CHANGED, n.getValue()[0], n.getValue()[1], this.diffEvalContext));
        }
        return a;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        List<DiffItem> all = this.all();
        if (all.isEmpty()) {
            return "<NO DIFFS>";
        }
        StringBuilder sb = new StringBuilder();
        this.print("", all, sb);
        return sb.toString();
    }

    private void print(String prefix, List<DiffItem> all, StringBuilder sb) {
        for (DiffItem diffItem : all) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(prefix).append(diffItem.toString());
            List<DiffItem> c = diffItem.children();
            if (c.size() <= 0) continue;
            this.print(prefix + "  ", c, sb);
        }
    }
}

