/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceLocation;
import net.thevpc.nuts.indexer.NutsIndexSubscriber;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManager;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManagerPool;
import net.thevpc.nuts.indexer.NutsIndexerUtils;
import net.thevpc.nuts.indexer.NutsWorkspacePool;
import net.thevpc.nuts.indexer.services.DataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class RefreshDataService {
    @Autowired
    private DataService dataService;
    private static final Logger logger = LoggerFactory.getLogger(RefreshDataService.class);
    @Autowired
    private NutsIndexSubscriberListManagerPool indexSubscriberListManagerPool;
    @Autowired
    private NutsWorkspacePool workspacePool;
    private NutsIndexSubscriberListManager subscriberManager;

    @PostConstruct
    private void init() {
        this.subscriberManager = this.indexSubscriberListManagerPool.openSubscriberListManager("default");
    }

    @Scheduled(fixedDelay=3600000L)
    public void refreshData() {
        List subscribers = this.subscriberManager.getSubscribers();
        for (NutsIndexSubscriber subscriber : subscribers) {
            logger.info("Refreshing data for subscriber " + subscriber.cacheFolderName() + " started!");
            logger.info("Refreshing components data for subscriber " + subscriber.cacheFolderName() + " started!");
            this.refreshSubscriberData(subscriber);
            logger.info("Refreshing components data for subscriber " + subscriber.cacheFolderName() + " finished!");
            logger.info("Refreshing data for subscriber " + subscriber.cacheFolderName() + " finished!");
        }
    }

    private void refreshSubscriberData(NutsIndexSubscriber subscriber) {
        Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
        if (iterator.hasNext()) {
            NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
            NutsSession session = this.workspacePool.openWorkspace(workspaceLocation.getLocation());
            Map<String, NutsId> oldData = this.dataService.getAllData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName())).stream().collect(Collectors.toMap(map -> (String)map.get("stringId"), map -> NutsIndexerUtils.mapToNutsId((Map)map, (NutsSession)session), (v1, v2) -> v1));
            NutsIterator definitions = session.search().setRepositoryFilter(session.repos().filter().byUuid(new String[]{subscriber.getUuid()})).setFailFast(false).setContent(false).setEffective(true).getResultDefinitions().iterator();
            ArrayList<Map> dataToIndex = new ArrayList<Map>();
            HashMap visited = new HashMap();
            while (definitions.hasNext()) {
                NutsDefinition definition = (NutsDefinition)definitions.next();
                Map id = NutsIndexerUtils.nutsIdToMap((NutsId)definition.getId());
                if (oldData.containsKey(id.get("stringId"))) {
                    visited.put(id.get("stringId"), true);
                    oldData.remove(id.get("stringId"));
                    continue;
                }
                if (visited.getOrDefault(id.get("stringId"), false).booleanValue()) continue;
                visited.put(id.get("stringId"), true);
                NutsDependency[] directDependencies = definition.getEffectiveDescriptor().getDependencies();
                id.put("dependencies", NutsElements.of((NutsSession)session).json().setValue(Arrays.stream(directDependencies).map(Object::toString).collect(Collectors.toList())).setNtf(false).format().filteredText());
                dataToIndex.add(id);
            }
            this.dataService.indexMultipleData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), dataToIndex);
            this.dataService.deleteMultipleData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), oldData.values().stream().map(NutsIndexerUtils::nutsIdToMap).collect(Collectors.toList()));
        }
    }
}

