/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NutsIndexerUtils {
    public static Path getCacheDir(NutsSession session, String entity) {
        String k = "NutsIndexerUtils.CACHE." + entity;
        String m = session.env().getPropertyElement(k).asString();
        if (m == null) {
            m = session.locations().getStoreLocation(NutsIdResolver.of((NutsSession)session).resolveId(NutsIndexerUtils.class), NutsStoreLocation.CACHE) + File.separator + entity;
            session.env().setProperty(k, (Object)m);
        }
        return new File(m).toPath();
    }

    public static Map<String, String> nutsRepositoryToMap(NutsRepository repository, int level, NutsSession session) {
        if (repository == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("name", repository.getName());
        entity.put("type", repository.getRepositoryType());
        entity.put("location", repository.config().getLocation().toString());
        entity.put("enabled", String.valueOf(repository.config().isEnabled()));
        entity.put("speed", String.valueOf(repository.config().getSpeed()));
        NutsWorkspace ws = repository.getWorkspace();
        if (level == 0) {
            entity.put("mirrors", Arrays.toString(Arrays.stream(repository.config().setSession(session).getMirrors()).map(nutsRepository -> NutsIndexerUtils.mapToJson((Map)NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)nutsRepository, (int)(level + 1), (NutsSession)session), (NutsSession)session)).toArray()));
            entity.put("parents", NutsIndexerUtils.mapToJson((Map)NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)repository.getParentRepository(), (int)(level + 1), (NutsSession)session), (NutsSession)session));
        }
        return entity;
    }

    public static String mapToJson(Map<String, String> map, NutsSession session) {
        StringWriter s = new StringWriter();
        NutsElements.of((NutsSession)session).json().setValue(map).setNtf(false).print((Writer)s);
        return s.toString();
    }

    public static Map<String, String> nutsRepositoryToMap(NutsRepository repository, NutsSession session) {
        return NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)repository, (int)0, (NutsSession)session);
    }

    public static Map<String, String> nutsIdToMap(NutsId id) {
        HashMap<String, String> entity = new HashMap<String, String>();
        id = id.builder().setFace(StringUtils.isEmpty((Object)id.getFace()) ? "default" : id.getFace()).build();
        NutsIndexerUtils._condPut(entity, (String)"name", (String)id.getArtifactId());
        NutsIndexerUtils._condPut(entity, (String)"namespace", (String)id.getRepository());
        NutsIndexerUtils._condPut(entity, (String)"group", (String)id.getGroupId());
        NutsIndexerUtils._condPut(entity, (String)"version", (String)id.getVersion().getValue());
        NutsIndexerUtils._condPut(entity, (String)"face", (String)id.getFace());
        NutsIndexerUtils._condPut(entity, (String)"os", (String)String.join((CharSequence)",", id.getCondition().getOs()));
        NutsIndexerUtils._condPut(entity, (String)"osdist", (String)String.join((CharSequence)",", id.getCondition().getOsDist()));
        NutsIndexerUtils._condPut(entity, (String)"arch", (String)String.join((CharSequence)",", id.getCondition().getArch()));
        NutsIndexerUtils._condPut(entity, (String)"platform", (String)String.join((CharSequence)",", id.getCondition().getPlatform()));
        NutsIndexerUtils._condPut(entity, (String)"profile", (String)String.join((CharSequence)",", id.getCondition().getProfile()));
        NutsIndexerUtils._condPut(entity, (String)"desktop", (String)String.join((CharSequence)",", id.getCondition().getDesktopEnvironment()));
        NutsIndexerUtils._condPut(entity, (String)"classifier", (String)id.getClassifier());
        NutsIndexerUtils._condPut(entity, (String)"stringId", (String)id.toString());
        return entity;
    }

    public static Map<String, String> nutsDependencyToMap(NutsDependency dependency) {
        HashMap<String, String> entity = new HashMap<String, String>();
        NutsIndexerUtils._condPut(entity, (String)"name", (String)dependency.getArtifactId());
        NutsIndexerUtils._condPut(entity, (String)"namespace", (String)dependency.getRepository());
        NutsIndexerUtils._condPut(entity, (String)"group", (String)dependency.getGroupId());
        NutsIndexerUtils._condPut(entity, (String)"version", (String)dependency.getVersion().getValue());
        NutsId id2 = dependency.toId().builder().setFace(StringUtils.isEmpty((Object)dependency.toId().getFace()) ? "default" : dependency.toId().getFace()).build();
        NutsIndexerUtils._condPut(entity, (String)"face", (String)id2.getFace());
        NutsIndexerUtils._condPut(entity, (String)"os", (String)String.join((CharSequence)",", id2.getCondition().getOs()));
        NutsIndexerUtils._condPut(entity, (String)"osdist", (String)String.join((CharSequence)",", id2.getCondition().getOsDist()));
        NutsIndexerUtils._condPut(entity, (String)"arch", (String)String.join((CharSequence)",", id2.getCondition().getArch()));
        NutsIndexerUtils._condPut(entity, (String)"platform", (String)String.join((CharSequence)",", id2.getCondition().getPlatform()));
        NutsIndexerUtils._condPut(entity, (String)"profile", (String)String.join((CharSequence)",", id2.getCondition().getProfile()));
        NutsIndexerUtils._condPut(entity, (String)"desktop", (String)String.join((CharSequence)",", id2.getCondition().getDesktopEnvironment()));
        NutsIndexerUtils._condPut(entity, (String)"classifier", (String)id2.getClassifier());
        NutsIndexerUtils._condPut(entity, (String)"stringId", (String)id2.toString());
        return entity;
    }

    private static void _condPut(Map<String, String> m, String k, String v) {
        if (!NutsUtilStrings.trim((String)v).isEmpty()) {
            m.put(k, v);
        }
    }

    public static BooleanQuery nutsIdToQuery(String name, String namespace, String group, String version, String os, String osDist, String arch, String platform, String desktopEnvironment, String classifier) {
        return new BooleanQuery.Builder().add((Query)new PhraseQuery.Builder().add(new Term("name", name)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("namespace", namespace)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("group", group)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("version", version)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("os", os)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("osdist", osDist)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("arch", arch)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("platform", platform)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("desktop", desktopEnvironment)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("classifier", classifier)).build(), BooleanClause.Occur.MUST).add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD)).build();
    }

    public static NutsId mapToNutsId(Map<String, String> map, NutsSession session) {
        return NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsUtilStrings.trim((String)map.get("name"))).setRepository(NutsUtilStrings.trim((String)map.get("namespace"))).setGroupId(NutsUtilStrings.trim((String)map.get("group"))).setVersion(NutsUtilStrings.trim((String)map.get("version"))).setCondition(NutsEnvConditionBuilder.of((NutsSession)session).setArch(new String[]{NutsUtilStrings.trim((String)map.get("arch"))}).setOs(new String[]{NutsUtilStrings.trim((String)map.get("os"))}).setOsDist(new String[]{NutsUtilStrings.trim((String)map.get("osdist"))}).setPlatform(new String[]{NutsUtilStrings.trim((String)map.get("platform"))}).setDesktopEnvironment(new String[]{NutsUtilStrings.trim((String)map.get("desktop"))})).setClassifier(NutsUtilStrings.trim((String)map.get("classifier"))).build();
    }

    public static Query mapToQuery(Map<String, String> map, String ... exclus) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Set set = Arrays.stream(exclus).collect(Collectors.toSet());
        if (set.size() > 0) {
            set.add("stringId");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (set.contains(entry.getKey())) continue;
            builder.add((Query)new PhraseQuery.Builder().add(new Term(entry.getKey(), NutsUtilStrings.trim((String)entry.getValue()))).build(), BooleanClause.Occur.MUST);
        }
        builder.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD));
        return builder.build();
    }
}

