/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceLocation;
import net.thevpc.nuts.indexer.NutsIndexSubscriber;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListConfig;

public class NutsIndexSubscriberListManager {
    private String name;
    private Map<String, NutsIndexSubscriber> subscribers = new LinkedHashMap();
    private NutsIndexSubscriberListConfig config;
    private NutsWorkspace defaultWorkspace;

    public NutsIndexSubscriberListManager(NutsWorkspace ws, NutsSession session, String name) {
        this.defaultWorkspace = ws;
        if (name == null || name.trim().isEmpty()) {
            name = "default";
        }
        this.name = name.trim();
        Path file = this.getConfigFile(session);
        if (Files.exists(file, new LinkOption[0])) {
            this.config = (NutsIndexSubscriberListConfig)this.defaultWorkspace.elem().setContentType(NutsContentType.JSON).parse(file, NutsIndexSubscriberListConfig.class);
            if (this.config.getSubscribers() != null) {
                for (NutsIndexSubscriber var : this.config.getSubscribers()) {
                    this.subscribers.put(var.getUuid(), var);
                }
            }
        } else {
            this.config = new NutsIndexSubscriberListConfig().setUuid(UUID.randomUUID().toString()).setName("default-config");
            this.save(session);
        }
    }

    private Path getConfigFile(NutsSession session) {
        return Paths.get(this.defaultWorkspace.locations().getStoreLocation(this.defaultWorkspace.id().setSession(session).resolveId(NutsIndexSubscriberListManager.class), NutsStoreLocation.CONFIG), new String[0]).resolve(this.name + "-nuts-subscriber-list.json");
    }

    public List<NutsIndexSubscriber> getSubscribers() {
        return new ArrayList<NutsIndexSubscriber>(this.subscribers.values());
    }

    public NutsIndexSubscriber getSubscriber(String uuid) {
        NutsIndexSubscriber subscriber = (NutsIndexSubscriber)this.subscribers.get(uuid);
        if (subscriber == null) {
            throw new NoSuchElementException("subscriber with " + uuid + " does not exist");
        }
        return subscriber.copy();
    }

    public NutsIndexSubscriberListManager setSubscribers(Map<String, NutsIndexSubscriber> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    public NutsIndexSubscriberListConfig getConfig() {
        return this.config;
    }

    public NutsIndexSubscriberListManager setConfig(NutsIndexSubscriberListConfig config) {
        this.config = config;
        return this;
    }

    public NutsIndexSubscriber subscribe(String repositoryUuid, NutsWorkspaceLocation workspaceLocation, NutsSession session) {
        if (this.subscribers.containsKey(repositoryUuid)) {
            ((NutsIndexSubscriber)this.subscribers.get(repositoryUuid)).getWorkspaceLocations().put(workspaceLocation.getUuid(), workspaceLocation.copy());
        } else {
            this.subscribers.put(repositoryUuid, new NutsIndexSubscriber().setUuid(repositoryUuid).setName(this.getRepositoryNameFromUuid(repositoryUuid)).setWorkspaceLocations(Collections.singletonMap(workspaceLocation.getUuid(), workspaceLocation.copy())));
        }
        this.save(session);
        return (NutsIndexSubscriber)this.subscribers.get(repositoryUuid);
    }

    private String getRepositoryNameFromUuid(String repositoryUuid) {
        NutsRepository[] repositories;
        for (NutsRepository repository : repositories = this.defaultWorkspace.repos().getRepositories()) {
            if (!repository.getUuid().equals(repositoryUuid)) continue;
            return repository.getName();
        }
        throw new NoSuchElementException();
    }

    private void save(NutsSession session) {
        this.config.setSubscribers((List)(this.subscribers.isEmpty() ? null : new ArrayList(this.subscribers.values())));
        Path file = this.getConfigFile(session);
        this.defaultWorkspace.elem().setContentType(NutsContentType.JSON).setValue((Object)this.config).print(file);
    }

    public boolean unsubscribe(String repositoryUuid, NutsWorkspaceLocation workspaceLocation, NutsSession session) {
        boolean b;
        boolean bl = b = ((NutsIndexSubscriber)this.subscribers.get(repositoryUuid)).getWorkspaceLocations().remove(workspaceLocation.getUuid()) != null;
        if (((NutsIndexSubscriber)this.subscribers.get(repositoryUuid)).getWorkspaceLocations().isEmpty()) {
            boolean bl2 = b = this.subscribers.remove(repositoryUuid) != null;
        }
        if (b) {
            this.save(session);
        }
        return b;
    }

    public boolean isSubscribed(String repositoryUuid, NutsWorkspaceLocation workspaceLocation) {
        return this.subscribers.containsKey(repositoryUuid) && ((NutsIndexSubscriber)this.subscribers.get(repositoryUuid)).getWorkspaceLocations().containsKey(workspaceLocation.getUuid());
    }

    public NutsWorkspace getDefaultWorkspace() {
        return this.defaultWorkspace;
    }
}

