/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer.services;

import javax.annotation.PostConstruct;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManager;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManagerPool;
import net.thevpc.nuts.indexer.NutsWorkspaceListManagerPool;
import net.thevpc.nuts.indexer.NutsWorkspacePool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"indexer/subscription"})
public class NutsSubscriptionController {
    @Autowired
    private NutsWorkspaceListManagerPool listManagerPool;
    @Autowired
    private NutsIndexSubscriberListManagerPool indexSubscriberListManagerPool;
    @Autowired
    private NutsWorkspacePool workspacePool;
    private NutsWorkspaceListManager workspaceManager;
    private NutsIndexSubscriberListManager subscriberManager;

    @PostConstruct
    private void init() {
        this.workspaceManager = this.listManagerPool.openListManager("default");
        this.subscriberManager = this.indexSubscriberListManagerPool.openSubscriberListManager("default");
    }

    @RequestMapping(value={"subscribe"})
    public ResponseEntity<Void> subscribe(@RequestParam(value="workspaceLocation") String workspaceLocation, @RequestParam(value="repositoryUuid") String repositoryUuid) {
        NutsRepository[] repositories;
        NutsWorkspace workspace = this.workspacePool.openWorkspace(workspaceLocation);
        workspace = workspace.createSession().getWorkspace();
        for (NutsRepository repository : repositories = workspace.repos().getRepositories()) {
            if (!repository.getUuid().equals(repositoryUuid)) continue;
            this.subscriberManager.subscribe(repositoryUuid, this.workspaceManager.getWorkspaceLocation(workspace.getUuid()), this.subscriberManager.getDefaultWorkspace().createSession());
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @RequestMapping(value={"unsubscribe"})
    public ResponseEntity<Void> unsubscribe(@RequestParam(value="workspaceLocation") String workspaceLocation, @RequestParam(value="repositoryUuid") String repositoryUuid) {
        NutsRepository[] repositories;
        NutsWorkspace workspace = this.workspacePool.openWorkspace(workspaceLocation);
        workspace = workspace.createSession().getWorkspace();
        for (NutsRepository repository : repositories = workspace.repos().getRepositories()) {
            if (!repository.getUuid().equals(repositoryUuid)) continue;
            this.subscriberManager.unsubscribe(repositoryUuid, this.workspaceManager.getWorkspaceLocation(workspace.getUuid()), this.subscriberManager.getDefaultWorkspace().createSession());
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @RequestMapping(value={"isSubscribed"})
    public ResponseEntity<Boolean> isSubscribed(@RequestParam(value="workspaceLocation") String workspaceLocation, @RequestParam(value="repositoryUuid") String repositoryUuid) {
        NutsRepository[] repositories;
        System.out.println(workspaceLocation + " " + repositoryUuid);
        NutsWorkspace workspace = this.workspacePool.openWorkspace(workspaceLocation);
        workspace = workspace.createSession().getWorkspace();
        for (NutsRepository repository : repositories = workspace.repos().getRepositories()) {
            if (!repository.getUuid().equals(repositoryUuid)) continue;
            boolean subscribed = this.subscriberManager.isSubscribed(repositoryUuid, this.workspaceManager.getWorkspaceLocation(workspace.getUuid()));
            return ResponseEntity.ok((Object)subscribed);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }
}

