/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer.services;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.NutsWorkspaceLocation;
import net.thevpc.nuts.indexer.NutsIndexSubscriber;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManager;
import net.thevpc.nuts.indexer.NutsIndexSubscriberListManagerPool;
import net.thevpc.nuts.indexer.NutsIndexerUtils;
import net.thevpc.nuts.indexer.NutsWorkspaceListManagerPool;
import net.thevpc.nuts.indexer.NutsWorkspacePool;
import net.thevpc.nuts.indexer.services.DataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"indexer/id"})
public class NutsComponentController {
    @Autowired
    private DataService dataService;
    private static final Logger LOG = LoggerFactory.getLogger(NutsComponentController.class);
    @Autowired
    private NutsWorkspaceListManagerPool listManagerPool;
    @Autowired
    private NutsIndexSubscriberListManagerPool indexSubscriberListManagerPool;
    @Autowired
    private NutsWorkspacePool workspacePool;
    private NutsWorkspaceListManager workspaceManager;
    private NutsIndexSubscriberListManager subscriberManager;

    @PostConstruct
    private void init() {
        this.workspaceManager = this.listManagerPool.openListManager("default");
        this.subscriberManager = this.indexSubscriberListManagerPool.openSubscriberListManager("default");
    }

    @GetMapping(value={""}, produces={"application/json"})
    public ResponseEntity<List<Map<String, Object>>> getAll(@RequestParam(value="repositoryUuid") String repositoryUuid) {
        NutsIndexSubscriber subscriber = this.subscriberManager.getSubscriber(repositoryUuid);
        if (subscriber != null) {
            LOG.info("Getting all components data for subscriber " + subscriber.cacheFolderName());
            Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
            if (iterator.hasNext()) {
                NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
                NutsSession session = Nuts.openWorkspace((String[])new String[]{"--workspace", workspaceLocation.getLocation()});
                NutsWorkspace ws = session.getWorkspace();
                List rows = this.dataService.getAllData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()));
                List resData = this.cleanNutsIdMap(ws, rows);
                return ResponseEntity.ok((Object)resData);
            }
        }
        LOG.error("Error in getting all components data for subscriber " + repositoryUuid);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @GetMapping(value={"dependencies"}, produces={"application/json"})
    public ResponseEntity<List<Map<String, String>>> getDependencies(@RequestParam(value="repositoryUuid") String repositoryUuid, @RequestParam(value="name") String name, @RequestParam(value="namespace") String namespace, @RequestParam(value="group") String group, @RequestParam(value="version") String version, @RequestParam(value="os") String os, @RequestParam(value="osdist") String osdist, @RequestParam(value="arch") String arch, @RequestParam(value="face") String face, @RequestParam(value="all") Boolean all) {
        NutsIndexSubscriber subscriber = this.subscriberManager.getSubscriber(repositoryUuid);
        if (subscriber != null) {
            LOG.info("Getting dependencies of component " + name + " data for subscriber " + subscriber.cacheFolderName());
            Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
            if (iterator.hasNext()) {
                NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
                NutsSession session = Nuts.openWorkspace((String[])new String[]{"--workspace", workspaceLocation.getLocation()});
                NutsWorkspace ws = session.getWorkspace();
                NutsId id = ws.id().builder().setArtifactId(name).setRepository(namespace).setGroupId(group).setVersion(version).setArch(arch).setOs(os).setOsdist(osdist).setFace(face).build();
                List result = all != false ? this.dataService.getAllDependencies(ws, NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), id) : this.dataService.getDependencies(ws, NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), id);
                return ResponseEntity.ok((Object)result);
            }
        }
        LOG.error("Error in getting dependencies of component " + name + " data for subscriber " + repositoryUuid);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @GetMapping(value={"allVersions"}, produces={"application/json"})
    public ResponseEntity<List<Map<String, Object>>> getAllVersions(@RequestParam(value="repositoryUuid") String repositoryUuid, @RequestParam(value="name") String name, @RequestParam(value="namespace") String namespace, @RequestParam(value="group") String group, @RequestParam(value="os") String os, @RequestParam(value="osdist") String osdist, @RequestParam(value="arch") String arch, @RequestParam(value="face") String face) {
        NutsIndexSubscriber subscriber = this.subscriberManager.getSubscriber(repositoryUuid);
        if (subscriber != null) {
            LOG.info("Getting all versions of component " + name + " data for subscriber " + subscriber.cacheFolderName());
            Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
            if (iterator.hasNext()) {
                NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
                NutsSession session = Nuts.openWorkspace((String[])new String[]{"--workspace", workspaceLocation.getLocation()});
                NutsWorkspace ws = session.getWorkspace();
                NutsId id = ws.id().builder().setArtifactId(name).setRepository(namespace).setGroupId(group).setArch(arch).setOs(os).setOsdist(osdist).setFace(face).build();
                List rows = this.dataService.getAllVersions(ws, NutsIndexerUtils.getCacheDir((NutsSession)ws.createSession(), (String)subscriber.cacheFolderName()), id);
                List resData = this.cleanNutsIdMap(ws, rows);
                return ResponseEntity.ok((Object)resData);
            }
        }
        LOG.error("Error in getting all versions of component " + name + " data for subscriber " + repositoryUuid);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @GetMapping(value={"delete"}, produces={"application/json"})
    public ResponseEntity<Boolean> deleteComponent(@RequestParam(value="repositoryUuid") String repositoryUuid, @RequestParam(value="name") String name, @RequestParam(value="namespace") String namespace, @RequestParam(value="group") String group, @RequestParam(value="version") String version, @RequestParam(value="os") String os, @RequestParam(value="osdist") String osdist, @RequestParam(value="arch") String arch, @RequestParam(value="face") String face) {
        NutsIndexSubscriber subscriber = this.subscriberManager.getSubscriber(repositoryUuid);
        if (subscriber != null) {
            LOG.info("Deleting the component " + name + " data for subscriber " + subscriber.cacheFolderName());
            Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
            if (iterator.hasNext()) {
                NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
                NutsSession session = Nuts.openWorkspace((String[])new String[]{"--workspace", workspaceLocation.getLocation()});
                NutsWorkspace ws = session.getWorkspace();
                Map data = NutsIndexerUtils.nutsIdToMap((NutsId)ws.id().builder().setArtifactId(name).setRepository(namespace).setGroupId(group).setVersion(version).setArch(arch).setOs(os).setOsdist(osdist).setFace(face).build());
                this.dataService.deleteData(NutsIndexerUtils.getCacheDir((NutsSession)ws.createSession(), (String)subscriber.cacheFolderName()), data);
                return ResponseEntity.ok((Object)true);
            }
        }
        LOG.error("Error in deleting the component " + name + " data for subscriber " + repositoryUuid);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @GetMapping(value={"addData"}, produces={"application/json"})
    public ResponseEntity<Boolean> addDocument(@RequestParam(value="repositoryUuid") String repositoryUuid, @RequestParam(value="name") String name, @RequestParam(value="namespace") String namespace, @RequestParam(value="group") String group, @RequestParam(value="version") String version, @RequestParam(value="os") String os, @RequestParam(value="osdist") String osdist, @RequestParam(value="arch") String arch, @RequestParam(value="face") String face) {
        NutsIndexSubscriber subscriber = this.subscriberManager.getSubscriber(repositoryUuid);
        if (subscriber != null) {
            LOG.info("Getting all versions of component " + name + " data for subscriber " + subscriber.cacheFolderName());
            Iterator iterator = subscriber.getWorkspaceLocations().values().iterator();
            if (iterator.hasNext()) {
                NutsWorkspaceLocation workspaceLocation = (NutsWorkspaceLocation)iterator.next();
                NutsSession session = Nuts.openWorkspace((String[])new String[]{"--workspace", workspaceLocation.getLocation()});
                NutsWorkspace ws = session.getWorkspace();
                NutsId id = ws.id().builder().setArtifactId(name).setRepository(namespace).setGroupId(group).setVersion(version).setArch(arch).setOs(os).setOsdist(osdist).setFace(face).build();
                Map data = NutsIndexerUtils.nutsIdToMap((NutsId)id);
                List list = this.dataService.searchData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), data, null);
                if (list.isEmpty()) {
                    Iterator it = ws.search().setRepositoryFilter(ws.repos().filter().byUuid(new String[]{subscriber.getUuid()})).addId(id).setFailFast(false).setContent(false).setEffective(true).getResultDefinitions().iterator();
                    if (it.hasNext()) {
                        NutsDefinition definition = (NutsDefinition)it.next();
                        NutsDependency[] directDependencies = definition.getEffectiveDescriptor().getDependencies();
                        data.put("dependencies", ws.elem().setContentType(NutsContentType.JSON).setValue(Arrays.stream(directDependencies).map(Object::toString).collect(Collectors.toList())).setNtf(false).format().toString());
                        this.dataService.indexData(NutsIndexerUtils.getCacheDir((NutsSession)session, (String)subscriber.cacheFolderName()), data);
                    } else {
                        ResponseEntity.ok((Object)false);
                    }
                }
                return ResponseEntity.ok((Object)true);
            }
        }
        LOG.error("Error in deleting the component " + name + " data for subscriber " + repositoryUuid);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    private List<Map<String, Object>> cleanNutsIdMap(NutsWorkspace ws, List<Map<String, String>> rows) {
        ArrayList<Map<String, Object>> resData = new ArrayList<Map<String, Object>>();
        for (Map<String, String> row : rows) {
            String[] array;
            HashMap<String, String> d = new HashMap<String, String>(row);
            if (d.containsKey("dependencies")) {
                array = (String[])ws.elem().setContentType(NutsContentType.JSON).parse((Reader)new StringReader(row.get("dependencies")), String[].class);
                ArrayList<Map> dependencies = new ArrayList<Map>();
                for (String s : array) {
                    dependencies.add(NutsIndexerUtils.nutsIdToMap((NutsId)ws.id().parser().parse(s)));
                }
                d.put("dependencies", (String)((Object)dependencies));
            }
            if (d.containsKey("allDependencies")) {
                array = (String[])ws.elem().setContentType(NutsContentType.JSON).parse((Reader)new StringReader(row.get("allDependencies")), String[].class);
                ArrayList<Map> allDependencies = new ArrayList<Map>();
                for (String s : array) {
                    allDependencies.add(NutsIndexerUtils.nutsIdToMap((NutsId)ws.id().parser().parse(s)));
                }
                d.put("allDependencies", (String)((Object)allDependencies));
            }
            resData.add(d);
        }
        return resData;
    }
}

