/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer.services;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.indexer.NutsIndexerUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.springframework.stereotype.Service;

@Service
public class DataService {
    public void indexData(Path dirPath, Map<String, String> data) {
        this.indexMultipleData(dirPath, Collections.singletonList(data));
    }

    public void indexMultipleData(Path dirPath, List<Map<String, String>> data) {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        FSDirectory index = null;
        IndexWriterConfig config = null;
        IndexWriter writer = null;
        try {
            index = FSDirectory.open((Path)dirPath);
            config = new IndexWriterConfig((Analyzer)analyzer);
            writer = new IndexWriter((Directory)index, config);
            for (Map<String, String> entity : data) {
                Document document = this.mapToDocument(entity);
                writer.addDocument((Iterable)document);
            }
            writer.close();
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void updateData(Path dirPath, Map<String, String> olddata, Map<String, String> data) {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        FSDirectory index = null;
        IndexWriterConfig config = null;
        IndexWriter writer = null;
        try {
            index = FSDirectory.open((Path)dirPath);
            config = new IndexWriterConfig((Analyzer)analyzer);
            writer = new IndexWriter((Directory)index, config);
            Query query = NutsIndexerUtils.mapToQuery(olddata, (String[])new String[0]);
            writer.deleteDocuments(new Query[]{query});
            Document document = this.mapToDocument(data);
            writer.addDocument((Iterable)document);
            writer.close();
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private Document mapToDocument(Map<String, String> data) {
        Document document = new Document();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            document.add((IndexableField)new StringField(entry.getKey(), NutsUtilStrings.trim((String)entry.getValue()), Field.Store.YES));
        }
        return document;
    }

    public void deleteData(Path dirPath, Map<String, String> data) {
        this.deleteMultipleData(dirPath, Collections.singletonList(data));
    }

    public void deleteMultipleData(Path dirPath, List<Map<String, String>> data) {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        FSDirectory index = null;
        IndexWriterConfig config = null;
        IndexWriter writer = null;
        try {
            index = FSDirectory.open((Path)dirPath);
            config = new IndexWriterConfig((Analyzer)analyzer);
            writer = new IndexWriter((Directory)index, config);
            for (Map<String, String> entity : data) {
                Query query = NutsIndexerUtils.mapToQuery(entity, (String[])new String[0]);
                writer.deleteDocuments(new Query[]{query});
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Map<String, String>> getAllData(Path dirPath) {
        return this.searchData(dirPath, null, null);
    }

    public List<Map<String, String>> searchData(Path dirPath, Map<String, String> data, Query query) {
        FSDirectory index = null;
        DirectoryReader reader = null;
        IndexSearcher searcher = null;
        TopDocs topDocs = null;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            index = FSDirectory.open((Path)dirPath);
            reader = DirectoryReader.open((Directory)index);
            searcher = new IndexSearcher((IndexReader)reader);
            topDocs = searcher.search((Query)(data == null ? (query == null ? new MatchAllDocsQuery() : query) : (query == null ? NutsIndexerUtils.mapToQuery(data, (String[])new String[0]) : query)), Integer.MAX_VALUE);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document document = null;
                HashMap<String, String> res = new HashMap<String, String>();
                document = searcher.doc(scoreDoc.doc);
                for (IndexableField field : document.getFields()) {
                    res.put(field.name(), field.stringValue());
                }
                result.add(res);
            }
        }
        catch (IOException e) {
            return new ArrayList<Map<String, String>>();
        }
        return result;
    }

    public List<Map<String, String>> getAllDependencies(NutsWorkspace ws, Path dirPath, NutsId id) {
        List rows = this.searchData(dirPath, NutsIndexerUtils.nutsIdToMap((NutsId)id), null);
        if (rows.isEmpty()) {
            return null;
        }
        Map row = (Map)rows.get(0);
        if (!row.containsKey("allDependencies")) {
            List allDependencies = ws.search().setBasePackage(false).setInlineDependencies(true).addId(id).setFailFast(false).setContent(false).getResultIds().list();
            HashMap oldRow = new HashMap(row);
            row.put("allDependencies", ws.elem().setContentType(NutsContentType.JSON).setValue(allDependencies.stream().map(Object::toString).collect(Collectors.toList())).setNtf(false).format().toString());
            this.updateData(dirPath, oldRow, row);
        }
        String[] array = (String[])ws.elem().setContentType(NutsContentType.JSON).parse((Reader)new StringReader((String)row.get("allDependencies")), String[].class);
        List<Map<String, String>> allDependencies = Arrays.stream(array).map(s -> NutsIndexerUtils.nutsIdToMap((NutsId)ws.id().parser().parse(s))).collect(Collectors.toList());
        return allDependencies;
    }

    public List<Map<String, String>> getDependencies(NutsWorkspace ws, Path dirPath, NutsId id) {
        List rows = this.searchData(dirPath, NutsIndexerUtils.nutsIdToMap((NutsId)id), null);
        if (rows.isEmpty()) {
            return null;
        }
        Map row = (Map)rows.get(0);
        String[] array = (String[])ws.elem().setContentType(NutsContentType.JSON).parse((Reader)new StringReader((String)row.get("dependencies")), String[].class);
        List<Map<String, String>> dependencies = Arrays.stream(array).map(s -> NutsIndexerUtils.nutsIdToMap((NutsId)ws.id().parser().parse(s))).collect(Collectors.toList());
        return dependencies;
    }

    public List<Map<String, String>> getAllVersions(NutsWorkspace ws, Path dirPath, NutsId id) {
        Map data = NutsIndexerUtils.nutsIdToMap((NutsId)id);
        List rows = this.searchData(dirPath, null, NutsIndexerUtils.mapToQuery((Map)data, (String[])new String[]{"version"}));
        return rows;
    }
}

