/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.indexer;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NutsIndexerUtils {
    public static Path getCacheDir(NutsSession session, String entity) {
        String k = "NutsIndexerUtils.CACHE." + entity;
        NutsWorkspace ws = session.getWorkspace();
        String m = (String)ws.env().getProperty(k);
        if (m == null) {
            m = ws.locations().getStoreLocation(ws.id().setSession(session).resolveId(NutsIndexerUtils.class), NutsStoreLocation.CACHE) + File.separator + entity;
            ws.env().setProperty(k, (Object)m);
        }
        return new File(m).toPath();
    }

    public static Map<String, String> nutsRepositoryToMap(NutsRepository repository, int level, NutsSession session) {
        if (repository == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("name", repository.getName());
        entity.put("type", repository.getRepositoryType());
        entity.put("location", repository.config().getLocation(false));
        entity.put("enabled", String.valueOf(repository.config().isEnabled()));
        entity.put("speed", String.valueOf(repository.config().getSpeed()));
        NutsWorkspace ws = repository.getWorkspace();
        if (level == 0) {
            entity.put("mirrors", Arrays.toString(Arrays.stream(repository.config().setSession(session).getMirrors()).map(nutsRepository -> NutsIndexerUtils.mapToJson((Map)NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)nutsRepository, (int)(level + 1), (NutsSession)session), (NutsWorkspace)ws)).toArray()));
            entity.put("parents", NutsIndexerUtils.mapToJson((Map)NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)repository.getParentRepository(), (int)(level + 1), (NutsSession)session), (NutsWorkspace)ws));
        }
        return entity;
    }

    public static String mapToJson(Map<String, String> map, NutsWorkspace ws) {
        StringWriter s = new StringWriter();
        ws.elem().setContentType(NutsContentType.JSON).setValue(map).print((Writer)s);
        return s.toString();
    }

    public static Map<String, String> nutsRepositoryToMap(NutsRepository repository, NutsSession session) {
        return NutsIndexerUtils.nutsRepositoryToMap((NutsRepository)repository, (int)0, (NutsSession)session);
    }

    public static Map<String, String> nutsIdToMap(NutsId id) {
        HashMap<String, String> entity = new HashMap<String, String>();
        id = id.builder().setFace(StringUtils.isEmpty((Object)id.getFace()) ? "default" : id.getFace()).build();
        NutsIndexerUtils._condPut(entity, (String)"name", (String)id.getArtifactId());
        NutsIndexerUtils._condPut(entity, (String)"namespace", (String)id.getRepository());
        NutsIndexerUtils._condPut(entity, (String)"group", (String)id.getGroupId());
        NutsIndexerUtils._condPut(entity, (String)"version", (String)id.getVersion().getValue());
        NutsIndexerUtils._condPut(entity, (String)"face", (String)id.getFace());
        NutsIndexerUtils._condPut(entity, (String)"os", (String)id.getOs());
        NutsIndexerUtils._condPut(entity, (String)"osdist", (String)id.getOsdist());
        NutsIndexerUtils._condPut(entity, (String)"arch", (String)id.getArch());
        NutsIndexerUtils._condPut(entity, (String)"classifier", (String)id.getClassifier());
        NutsIndexerUtils._condPut(entity, (String)"stringId", (String)id.toString());
        return entity;
    }

    public static Map<String, String> nutsDependencyToMap(NutsDependency dependency) {
        HashMap<String, String> entity = new HashMap<String, String>();
        NutsIndexerUtils._condPut(entity, (String)"name", (String)dependency.getArtifactId());
        NutsIndexerUtils._condPut(entity, (String)"namespace", (String)dependency.getRepository());
        NutsIndexerUtils._condPut(entity, (String)"group", (String)dependency.getGroupId());
        NutsIndexerUtils._condPut(entity, (String)"version", (String)dependency.getVersion().getValue());
        NutsId id2 = dependency.toId().builder().setFace(StringUtils.isEmpty((Object)dependency.toId().getFace()) ? "default" : dependency.toId().getFace()).build();
        NutsIndexerUtils._condPut(entity, (String)"face", (String)id2.getFace());
        NutsIndexerUtils._condPut(entity, (String)"os", (String)id2.getOs());
        NutsIndexerUtils._condPut(entity, (String)"osdist", (String)id2.getOsdist());
        NutsIndexerUtils._condPut(entity, (String)"arch", (String)id2.getArch());
        NutsIndexerUtils._condPut(entity, (String)"classifier", (String)id2.getClassifier());
        NutsIndexerUtils._condPut(entity, (String)"stringId", (String)id2.toString());
        return entity;
    }

    private static void _condPut(Map<String, String> m, String k, String v) {
        if (!NutsUtilStrings.trim((String)v).isEmpty()) {
            m.put(k, v);
        }
    }

    public static BooleanQuery nutsIdToQuery(String name, String namespace, String group, String version, String os, String osdist, String arch, String classifier) {
        return new BooleanQuery.Builder().add((Query)new PhraseQuery.Builder().add(new Term("name", name)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("namespace", namespace)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("group", group)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("version", version)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("os", os)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("osdist", osdist)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("arch", arch)).build(), BooleanClause.Occur.MUST).add((Query)new PhraseQuery.Builder().add(new Term("classifier", classifier)).build(), BooleanClause.Occur.MUST).add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD)).build();
    }

    public static NutsId mapToNutsId(Map<String, String> map, NutsWorkspace ws) {
        return ws.id().builder().setArtifactId(NutsUtilStrings.trim((String)map.get("name"))).setRepository(NutsUtilStrings.trim((String)map.get("namespace"))).setGroupId(NutsUtilStrings.trim((String)map.get("group"))).setVersion(NutsUtilStrings.trim((String)map.get("version"))).setOs(NutsUtilStrings.trim((String)map.get("os"))).setOsdist(NutsUtilStrings.trim((String)map.get("osdist"))).setClassifier(NutsUtilStrings.trim((String)map.get("classifier"))).setArch(NutsUtilStrings.trim((String)map.get("arch"))).build();
    }

    public static Query mapToQuery(Map<String, String> map, String ... exclus) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Set set = Arrays.stream(exclus).collect(Collectors.toSet());
        if (set.size() > 0) {
            set.add("stringId");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (set.contains(entry.getKey())) continue;
            builder.add((Query)new PhraseQuery.Builder().add(new Term(entry.getKey(), NutsUtilStrings.trim((String)entry.getValue()))).build(), BooleanClause.Occur.MUST);
        }
        builder.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD));
        return builder.build();
    }
}

