/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.remote;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ndb.nmysql.NMySqlService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlDatabaseConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.CachedMapFile;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.AtName;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.MysqlUtils;

public class RemoteMysqlDatabaseConfigService {
    private final RemoteMysqlDatabaseConfig config;
    private final NutsApplicationContext context;
    private final RemoteMysqlConfigService client;
    private final String name;

    public RemoteMysqlDatabaseConfigService(String name, RemoteMysqlDatabaseConfig config, RemoteMysqlConfigService client) {
        this.config = config;
        this.client = client;
        this.context = client.context;
        this.name = name;
    }

    public RemoteMysqlDatabaseConfig getConfig() {
        return this.config;
    }

    public RemoteMysqlDatabaseConfigService remove() {
        this.client.getConfig().getDatabases().remove(this.name);
        this.context.getSession().out().printf("%s db config removed.%n", new Object[]{this.getBracketsPrefix(this.name)});
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getName() + "@" + this.client.getName();
    }

    public void write(PrintStream out) {
        NutsSession session = this.context.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.getConfig()).setNtf(false).print((OutputStream)out);
    }

    public String pull(String localPath, boolean restore, boolean deleteRemote) {
        CachedMapFile lastRun = new CachedMapFile(this.context, "pull-" + this.getName());
        NutsSession session = this.context.getSession();
        if (lastRun.exists() && !session.getTerminal().ask().resetLine().forBoolean("a previous pull has failed. would you like to resume (yes) or ignore and re-run the pull (no).", new Object[0]).getBooleanValue().booleanValue()) {
            lastRun.reset();
        }
        NMySqlService ms = new NMySqlService(this.context);
        AtName locName = new AtName(this.getConfig().getLocalName());
        LocalMysqlDatabaseConfigService loc = ms.loadLocalMysqlConfig(locName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR).getDatabase(locName.getDatabaseName(), NutsOpenMode.OPEN_OR_ERROR);
        RemoteMysqlDatabaseConfig cconfig = this.getConfig();
        if (session.isPlainTrace()) {
            session.out().printf("%s remote restore%n", new Object[]{this.getBracketsPrefix(this.name)});
        }
        String remoteTempPath = null;
        if (lastRun.get("remoteTempPath") != null) {
            remoteTempPath = lastRun.get("remoteTempPath");
        } else {
            remoteTempPath = this.execRemoteNuts("net.thevpc.nuts.toolbox:nmysql", "backup", "--name", this.config.getRemoteName(), "");
            lastRun.put("remoteTempPath", remoteTempPath);
        }
        int t = remoteTempPath.indexOf(123);
        if (t > 0) {
            remoteTempPath = remoteTempPath.substring(t);
        }
        NutsElements elem = NutsElements.of((NutsSession)session);
        Map resMap = (Map)elem.parse(remoteTempPath.getBytes(), Map.class);
        String ppath = (String)resMap.get("path");
        if (NutsBlankable.isBlank((String)localPath)) {
            localPath = this.context.getVarFolder().resolve("pull-backups").resolve(this.client.getName() + "-" + this.getName()).resolve(Paths.get(ppath, new String[0]).getFileName().toString()).toString();
        }
        NutsPath remoteFullFilePath = NutsPath.of((String)(this.prepareSshServer(cconfig.getServer()) + "/" + ppath), (NutsSession)session);
        NutsTexts text = NutsTexts.of((NutsSession)session);
        if (session.isPlainTrace()) {
            session.out().printf("%s copy '%s' to '%s'%n", new Object[]{this.getBracketsPrefix(this.name), text.ofStyled(remoteFullFilePath.toString(), NutsTextStyle.path()), text.ofStyled(localPath, NutsTextStyle.path())});
        }
        if (lastRun.get("localPath") != null) {
            String s = lastRun.get("localPath");
            NutsCp.of((NutsSession)session).from(s).to(localPath).run();
        } else {
            if (Paths.get(localPath, new String[0]).getParent() != null) {
                try {
                    Files.createDirectories(Paths.get(localPath, new String[0]).getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new NutsIOException(session, (Throwable)e);
                }
            }
            this.context.getSession().exec().setExecutionType(NutsExecutionType.EMBEDDED).setSession(session.copy()).addCommand(new String[]{"nsh", "--bot", "-c", "cp", remoteFullFilePath.toString(), localPath}).setRedirectErrorStream(true).grabOutputString().setFailFast(true).run().getOutputString();
            lastRun.put("localPath", localPath);
        }
        if (lastRun.get("restored") != null) {
            String string = lastRun.get("restored");
        } else {
            loc.restore(localPath);
            lastRun.put("restored", "true");
        }
        if (deleteRemote) {
            if (session.isPlainTrace()) {
                session.out().printf("%s delete %s%n", new Object[]{this.getBracketsPrefix(this.name), remoteFullFilePath});
            }
            if (!lastRun.is("deleted")) {
                this.execRemoteNuts("nsh", "-c", "rm", remoteFullFilePath.getLocation());
                lastRun.put("deleted", "true");
            }
        }
        lastRun.dispose();
        return localPath;
    }

    public void push(String localPath, boolean backup) {
        NMySqlService ms = new NMySqlService(this.context);
        AtName locName = new AtName(this.getConfig().getLocalName());
        LocalMysqlDatabaseConfigService loc = ms.loadLocalMysqlConfig(locName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR).getDatabase(locName.getDatabaseName(), NutsOpenMode.OPEN_OR_ERROR);
        NutsSession session = this.context.getSession();
        if (backup) {
            localPath = loc.backup((String)localPath).path;
        } else if (NutsBlankable.isBlank((String)localPath)) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing local path", (Object[])new Object[0]), 2);
        }
        if (!new File(localPath).isFile()) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid local path %s", (Object[])new Object[]{localPath}), 2);
        }
        RemoteMysqlDatabaseConfig cconfig = this.getConfig();
        String remoteTempPath = null;
        String searchResultString = this.execRemoteNuts("search --!color --json net.thevpc.nuts.toolbox:nmysql --display temp-folder --installed --first");
        List result = (List)NutsElements.of((NutsSession)session).json().parse((Reader)new StringReader(searchResultString), List.class);
        if (result.isEmpty()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"Mysql is not installed on the remote machine", (Object[])new Object[0]));
        }
        remoteTempPath = (String)((Map)result.get(0)).get("temp-folder");
        String remoteFilePath = "/" + remoteTempPath + "-" + MysqlUtils.newDateString() + "-" + MysqlUtils.getFileName(localPath);
        NutsPath remoteFullFilePath = NutsPath.of((String)(this.prepareSshServer(cconfig.getServer()) + "/" + remoteFilePath), (NutsSession)session);
        NutsTexts text = NutsTexts.of((NutsSession)session);
        if (session.isPlainTrace()) {
            session.out().printf("%s copy %s to %s%n", new Object[]{this.getBracketsPrefix(this.name), text.ofStyled(localPath, NutsTextStyle.path()), remoteFullFilePath});
        }
        session.exec().addCommand(new String[]{"nsh", "--bot", "cp", localPath, remoteFullFilePath.getLocation()}).setSession(session).setRedirectErrorStream(true).grabOutputString().setFailFast(true).run();
        if (session.isPlainTrace()) {
            session.out().printf("%s remote restore %s%n", new Object[]{this.getBracketsPrefix(this.name), remoteFullFilePath});
        }
        this.execRemoteNuts("net.thevpc.nuts.toolbox:nmysql", "restore", "--name", this.config.getRemoteName(), remoteFilePath);
        if (session.isPlainTrace()) {
            session.out().printf("%s delete %s%n", new Object[]{this.getBracketsPrefix(this.name), remoteFilePath});
        }
        this.execRemoteNuts("nsh", "rm", remoteFilePath);
    }

    public String execRemoteNuts(List<String> cmd) {
        return this.execRemoteNuts(cmd.toArray(new String[0]));
    }

    public String execRemoteNuts(String ... cmd) {
        NutsSession session = this.context.getSession();
        NutsExecCommand b = session.exec().setSession(session.copy());
        if ("localhost".equals(this.config.getServer())) {
            b.addCommand(new String[]{"nuts"});
            b.addCommand(new String[]{"-b"});
            b.addCommand(new String[]{"-y"});
            b.addCommand(new String[]{"--bot"});
            b.addCommand(new String[]{"--trace=false"});
            b.addCommand(new String[]{"--json"});
            b.addCommand(cmd);
        } else {
            b.addCommand(new String[]{"nsh", "-c", "ssh"});
            b.addCommand(new String[]{this.config.getServer()});
            b.addCommand(new String[]{"/home/" + System.getProperty("user.name") + "/bin/nuts"});
            b.addCommand(new String[]{"-b"});
            b.addCommand(new String[]{"-y"});
            b.addCommand(new String[]{"--trace=false"});
            b.addCommand(new String[]{"--bot"});
            b.addCommand(new String[]{"--json"});
            b.addCommand(cmd);
        }
        if (session.isPlainTrace()) {
            NutsString ff = b.formatter().setEnvReplacer(envEntry -> {
                if (envEntry.getName().toLowerCase().contains("password") || envEntry.getName().toLowerCase().contains("pwd")) {
                    return "****";
                }
                return null;
            }).format();
            session.out().printf("[exec] %s%n", new Object[]{ff});
        }
        b.setRedirectErrorStream(true).grabOutputString().setFailFast(true);
        return b.run().getOutputString();
    }

    private String prepareSshServer(String server) {
        if (NutsBlankable.isBlank((String)server)) {
            server = "ssh://localhost";
        }
        if (!server.startsWith("ssh://")) {
            server = "ssh://" + server;
        }
        return server;
    }

    public NutsString getBracketsPrefix(String str) {
        return NutsTexts.of((NutsSession)this.context.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }
}

