/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.remote;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;

public class CachedMapFile {
    private final NutsApplicationContext context;
    private Map<String, String> map;
    private boolean enabled;
    private final NutsPath path;
    private boolean loaded;

    public CachedMapFile(NutsApplicationContext context, String name) {
        this(context, name, true);
    }

    public CachedMapFile(NutsApplicationContext context, String name, boolean enabled) {
        this.context = context;
        this.enabled = enabled;
        NutsId appId = context.getAppId();
        this.path = context.getTempFolder().resolve(appId.getGroupId() + "-" + appId.getArtifactId() + "-" + appId.getVersion()).resolve(name + ".json");
        if (enabled && this.path.isRegularFile()) {
            try {
                NutsSession session = context.getSession();
                this.map = (Map)NutsElements.of((NutsSession)session).json().parse(this.path, Map.class);
                this.loaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean exists() {
        return this.loaded;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CachedMapFile setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean contains(String k) {
        if (!this.enabled) {
            return false;
        }
        if (this.map == null) {
            return false;
        }
        return this.map.get(k) != null;
    }

    public String get(String k) {
        if (!this.enabled) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        return this.map.get(k);
    }

    public boolean is(String k) {
        return "true".equals(this.get(k));
    }

    public void put(String k) {
        this.put("k", "true");
    }

    public void put(String k, String v) {
        if (this.enabled) {
            if (this.map == null) {
                this.map = new HashMap<String, String>();
            }
            this.map.put(k, v);
            try {
                NutsSession session = this.context.getSession();
                NutsElements.of((NutsSession)session).setValue(this.map).json().setNtf(false).print(this.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.dispose();
        this.map = null;
    }

    public void dispose() {
        if (this.path != null) {
            this.path.delete();
        }
    }
}

