/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql;

import java.util.ArrayList;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ndb.NdbSupport;
import net.thevpc.nuts.toolbox.ndb.nmysql.NMySqlService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlDatabaseConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlDatabaseConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.AtName;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.MysqlUtils;
import net.thevpc.nuts.toolbox.ndb.util.NdbUtils;

public class NMysqlMain
implements NdbSupport {
    @Override
    public void run(NutsApplicationContext context, NutsCommandLine commandLine) {
        NMySqlService service = new NMySqlService(context);
        while (commandLine.hasNext()) {
            switch (commandLine.peek().getKey().getString()) {
                case "add": 
                case "create": {
                    commandLine.skip();
                    this.createOrUpdate(commandLine, true, service);
                    return;
                }
                case "update": {
                    commandLine.skip();
                    this.createOrUpdate(commandLine, false, service);
                    return;
                }
                case "remove": {
                    commandLine.skip();
                    this.runRemove(commandLine, service);
                    return;
                }
                case "list": {
                    commandLine.skip();
                    this.runList(commandLine, service, false);
                    return;
                }
                case "desc": {
                    commandLine.skip();
                    this.runList(commandLine, service, true);
                    return;
                }
                case "backup": {
                    commandLine.skip();
                    this.runBackupOrRestore(commandLine, true, service);
                    return;
                }
                case "restore": {
                    commandLine.skip();
                    this.runBackupOrRestore(commandLine, false, service);
                    return;
                }
                case "pull": {
                    commandLine.skip();
                    this.runPushOrPull(commandLine, true, service);
                    return;
                }
                case "push": {
                    commandLine.skip();
                    this.runPushOrPull(commandLine, false, service);
                    return;
                }
            }
            context.configureLast(commandLine);
        }
        this.runList(commandLine, service, false);
    }

    private void runPushOrPull(NutsCommandLine commandLine, boolean pull, NMySqlService service) {
        commandLine.setCommandName("mysql --remote " + (pull ? "pull" : "push"));
        AtName name = null;
        String path = null;
        block8: while (commandLine.hasNext()) {
            if (commandLine.peek().isOption()) {
                switch (commandLine.peek().getKey().getString()) {
                    case "--name": {
                        if (name == null) {
                            name = AtName.nextAppOption(commandLine);
                            continue block8;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block8;
                    }
                    case "--path": {
                        if (path == null) {
                            path = commandLine.nextString(new String[0]).getValue().getString();
                            continue block8;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block8;
                    }
                }
                service.getContext().configureLast(commandLine);
                continue;
            }
            if (name == null) {
                name = AtName.nextAppNonOption(commandLine);
                continue;
            }
            if (path == null) {
                path = commandLine.next().getString();
                continue;
            }
            commandLine.unexpectedArgument();
        }
        if (name == null) {
            name = new AtName("");
        }
        RemoteMysqlConfigService c = service.loadRemoteMysqlConfig(name.getConfigName(), NutsOpenMode.OPEN_OR_ERROR);
        RemoteMysqlDatabaseConfigService d = c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_ERROR);
        if (pull) {
            d.pull(path, true, true);
        } else {
            d.push(path, true);
        }
    }

    private void runBackupOrRestore(NutsCommandLine commandLine, boolean backup, NMySqlService service) {
        commandLine.setCommandName("mysql " + (backup ? "backup" : "restore"));
        AtName name = null;
        String path = null;
        block8: while (commandLine.hasNext()) {
            if (commandLine.peek().isOption()) {
                switch (commandLine.peek().getKey().getString()) {
                    case "--name": {
                        if (name == null) {
                            name = AtName.nextAppOption(commandLine);
                            continue block8;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block8;
                    }
                    case "--path": {
                        if (path == null) {
                            path = commandLine.nextString(new String[0]).getValue().getString();
                            continue block8;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block8;
                    }
                }
                service.getContext().configureLast(commandLine);
                continue;
            }
            if (name == null) {
                name = AtName.nextAppNonOption(commandLine);
                continue;
            }
            if (path == null) {
                path = commandLine.next().getString();
                continue;
            }
            commandLine.unexpectedArgument();
        }
        if (name == null) {
            name = new AtName("");
        }
        LocalMysqlConfigService c = service.loadLocalMysqlConfig(name.getConfigName(), NutsOpenMode.OPEN_OR_ERROR);
        LocalMysqlDatabaseConfigService d = c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_ERROR);
        NutsSession s = service.getContext().getSession();
        if (backup) {
            if (path == null) {
                path = d.getDatabaseName() + "-" + MysqlUtils.newDateString();
            }
            LocalMysqlDatabaseConfigService.ArchiveResult result = d.backup(path);
            s.out().printlnf((Object)result);
        } else {
            if (path == null) {
                commandLine.required(NutsMessage.cstyle((String)"missing --path", (Object[])new Object[0]));
            }
            LocalMysqlDatabaseConfigService.RestoreResult result = d.restore(path);
            s.out().printlnf((Object)result);
        }
    }

    private void createOrUpdate(NutsCommandLine commandLine, boolean add, NMySqlService service) {
        commandLine.setCommandName("mysql " + (add ? "add" : "set"));
        AtName name = null;
        Integer c_shutdown_wait_time = null;
        Integer c_startup_wait_time = null;
        Boolean c_kill = null;
        String c_archive_folder = null;
        String c_running_folder = null;
        String c_log_file = null;
        String c_mysql_command = null;
        String c_mysqldump_command = null;
        String user = null;
        String password = null;
        String dbname = null;
        AtName forRemote_remoteName = null;
        AtName forRemote_localName = null;
        String forRemote_server = null;
        Boolean expectedRemote = null;
        boolean askPassword = false;
        block40: while (commandLine.hasNext()) {
            if (commandLine.peek().isOption()) {
                switch (commandLine.peek().getKey().getString()) {
                    case "--name": {
                        if (name == null) {
                            name = AtName.nextAppOption(commandLine);
                            continue block40;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block40;
                    }
                    case "--shutdown-wait-time": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_shutdown_wait_time = commandLine.nextString(new String[0]).getValue().getInt();
                        continue block40;
                    }
                    case "--startup-wait-time": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_startup_wait_time = commandLine.nextString(new String[0]).getValue().getInt();
                        continue block40;
                    }
                    case "--backup-folder": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_archive_folder = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--running-folder": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_running_folder = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--log-file": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_log_file = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--mysql-command": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_mysql_command = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--mysqldump-command": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_mysqldump_command = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--kill": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        c_kill = commandLine.nextBoolean(new String[0]).getBooleanValue();
                        continue block40;
                    }
                    case "--user": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        user = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--password": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        password = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--ask-password": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        askPassword = commandLine.nextBoolean(new String[0]).getBooleanValue();
                        continue block40;
                    }
                    case "--db": {
                        if (expectedRemote == null) {
                            expectedRemote = false;
                        } else if (expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        dbname = commandLine.nextString(new String[0]).getValue().getString();
                        continue block40;
                    }
                    case "--local-name": {
                        if (expectedRemote == null) {
                            expectedRemote = true;
                        } else if (!expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        if (forRemote_localName == null) {
                            forRemote_localName = AtName.nextAppOption(commandLine);
                            continue block40;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block40;
                    }
                    case "--remote-name": {
                        if (expectedRemote == null) {
                            expectedRemote = true;
                        } else if (!expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        if (forRemote_remoteName == null) {
                            forRemote_remoteName = AtName.nextAppOption(commandLine);
                            continue block40;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block40;
                    }
                    case "--server": {
                        if (expectedRemote == null) {
                            expectedRemote = true;
                        } else if (!expectedRemote.booleanValue()) {
                            commandLine.unexpectedArgument();
                        }
                        if (forRemote_server == null) {
                            forRemote_server = commandLine.nextString(new String[0]).getValue().getString();
                            continue block40;
                        }
                        commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                        continue block40;
                    }
                    case "--local": {
                        commandLine.nextBoolean(new String[0]);
                        if (expectedRemote == null) {
                            expectedRemote = false;
                            continue block40;
                        }
                        if (!expectedRemote.booleanValue()) continue block40;
                        commandLine.unexpectedArgument();
                        continue block40;
                    }
                    case "--remote": {
                        commandLine.nextBoolean(new String[0]);
                        if (expectedRemote == null) {
                            expectedRemote = true;
                            continue block40;
                        }
                        if (expectedRemote.booleanValue()) continue block40;
                        commandLine.unexpectedArgument();
                        continue block40;
                    }
                }
                if (commandLine.peek().isNonOption()) {
                    if (name == null) {
                        name = AtName.nextAppOption(commandLine);
                        continue;
                    }
                    commandLine.unexpectedArgument(NutsMessage.cstyle((String)"already defined", (Object[])new Object[0]));
                    continue;
                }
                service.getContext().configureLast(commandLine);
                continue;
            }
            if (name == null) {
                name = AtName.nextAppNonOption(commandLine);
                continue;
            }
            commandLine.unexpectedArgument();
        }
        if (name == null) {
            name = new AtName("");
        }
        if (expectedRemote == null) {
            expectedRemote = false;
        }
        if (expectedRemote.booleanValue() && forRemote_server == null) {
            commandLine.required(NutsMessage.cstyle((String)"required --server option", (Object[])new Object[0]));
        }
        NutsSession session = service.getContext().getSession();
        NutsTexts factory = NutsTexts.of((NutsSession)session);
        if (commandLine.isExecMode()) {
            if (!expectedRemote.booleanValue()) {
                LocalMysqlConfigService c = service.loadLocalMysqlConfig(name.getConfigName(), add ? NutsOpenMode.OPEN_OR_CREATE : NutsOpenMode.OPEN_OR_ERROR);
                boolean overrideExisting = false;
                if (add) {
                    if (name.getDatabaseName().isEmpty()) {
                        if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) != null) {
                            overrideExisting = true;
                            if (!session.getTerminal().ask().resetLine().forBoolean("already exists %s. override?", new Object[]{factory.ofStyled(name.toString(), NutsTextStyle.primary3())}).setDefaultValue((Object)false).getBooleanValue().booleanValue()) {
                                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"already exists %s", (Object[])new Object[]{name}), 2);
                            }
                        }
                    } else if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) != null) {
                        overrideExisting = true;
                        if (!session.getTerminal().ask().resetLine().forBoolean("already exists %s. override?", new Object[]{factory.ofStyled(name.toString(), NutsTextStyle.primary3())}).setDefaultValue((Object)false).getBooleanValue().booleanValue()) {
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"already exists %s", (Object[])new Object[]{name}), 2);
                        }
                    }
                } else if (name.getDatabaseName().isEmpty()) {
                    if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"not found %s", (Object[])new Object[]{name}), 2);
                    }
                } else if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) == null) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"not found  %s", (Object[])new Object[]{name}), 2);
                }
                boolean someUpdates = false;
                if (name.getDatabaseName().isEmpty()) {
                    if (c_shutdown_wait_time != null) {
                        someUpdates = true;
                        c.getConfig().setShutdownWaitTime(c_shutdown_wait_time);
                    }
                    if (c_shutdown_wait_time != null) {
                        someUpdates = true;
                        c.getConfig().setStartupWaitTime(c_startup_wait_time);
                    }
                    if (c_archive_folder != null) {
                        someUpdates = true;
                        c.getConfig().setBackupFolder(c_archive_folder);
                    }
                    if (c_log_file != null) {
                        someUpdates = true;
                        c.getConfig().setLogFile(c_log_file);
                    }
                    if (c_running_folder != null) {
                        someUpdates = true;
                        c.getConfig().setRunningFolder(c_running_folder);
                    }
                    if (c_mysql_command != null) {
                        someUpdates = true;
                        c.getConfig().setMysqlCommand(c_mysql_command);
                    }
                    if (c_mysqldump_command != null) {
                        someUpdates = true;
                        c.getConfig().setMysqldumpCommand(c_mysqldump_command);
                    }
                    if (c_kill != null) {
                        someUpdates = true;
                        c.getConfig().setKill(c_kill);
                    }
                    if (someUpdates && session.isPlainTrace()) {
                        if (add) {
                            if (overrideExisting) {
                                session.out().printf("adding local config (with override) %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                            } else {
                                session.out().printf("adding local config %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                            }
                        } else if (overrideExisting) {
                            session.out().printf("updating local config (with override) %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                        } else {
                            session.out().printf("updating local config %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                        }
                    }
                } else {
                    LocalMysqlDatabaseConfigService r = c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_CREATE);
                    if (user != null) {
                        someUpdates = true;
                        r.getConfig().setUser(user);
                    }
                    if (password != null) {
                        someUpdates = true;
                        r.getConfig().setPassword(new String(session.security().createCredentials(password.toCharArray(), true, null)));
                    }
                    if (add && dbname == null) {
                        dbname = name.getDatabaseName();
                    }
                    if (dbname != null) {
                        someUpdates = true;
                        r.getConfig().setDatabaseName(dbname);
                    }
                    if (askPassword || !add && password == null) {
                        r.getConfig().setPassword(new String(session.security().createCredentials(session.getTerminal().readPassword("Password", new Object[0]), true, null)));
                    }
                    if (r.getConfig().getUser() == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing --user", (Object[])new Object[0]), 2);
                    }
                    if (r.getConfig().getPassword() == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing --password", (Object[])new Object[0]), 2);
                    }
                    if (r.getConfig().getDatabaseName() == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing --name", (Object[])new Object[0]), 2);
                    }
                    if (someUpdates && session.isPlainTrace()) {
                        if (add) {
                            if (overrideExisting) {
                                session.out().printf("adding local instance (with override) %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                            } else {
                                session.out().printf("adding local instance %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                            }
                        } else if (overrideExisting) {
                            session.out().printf("updating local instance (with override) %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                        } else {
                            session.out().printf("updating local instance %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                        }
                    }
                }
                if (!someUpdates) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nothing to save", (Object[])new Object[0]), 2);
                }
                c.saveConfig();
            } else {
                if (forRemote_localName == null && forRemote_remoteName == null) {
                    forRemote_localName = name;
                    forRemote_remoteName = name;
                } else if (forRemote_localName == null) {
                    forRemote_localName = forRemote_remoteName;
                } else if (forRemote_remoteName == null) {
                    forRemote_remoteName = forRemote_localName;
                }
                service.loadLocalMysqlConfig(forRemote_localName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR).getDatabase(forRemote_localName.getDatabaseName(), NutsOpenMode.OPEN_OR_ERROR);
                RemoteMysqlConfigService c = service.loadRemoteMysqlConfig(name.getConfigName(), NutsOpenMode.OPEN_OR_CREATE);
                boolean overrideExisting = false;
                if (add) {
                    if (name.getDatabaseName().isEmpty()) {
                        if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) != null) {
                            overrideExisting = true;
                            if (!session.getTerminal().ask().resetLine().forBoolean("already exists %s. override?", new Object[]{factory.ofStyled(name.toString(), NutsTextStyle.primary3())}).setDefaultValue((Object)false).getBooleanValue().booleanValue()) {
                                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"already exists %s", (Object[])new Object[]{name}), 2);
                            }
                        }
                    } else if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) != null) {
                        overrideExisting = true;
                        if (!session.getTerminal().ask().resetLine().forBoolean("already exists %s. override?", new Object[]{factory.ofStyled(name.toString(), NutsTextStyle.primary3())}).setDefaultValue((Object)false).getBooleanValue().booleanValue()) {
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"already exists %s", (Object[])new Object[]{name}), 2);
                        }
                    }
                } else if (name.getDatabaseName().isEmpty()) {
                    if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"not found %s", (Object[])new Object[]{name}), 2);
                    }
                } else if (c.getDatabase(name.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL) == null) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)("not found  %s" + name), (Object[])new Object[0]), 2);
                }
                boolean someUpdates = false;
                if (name.getDatabaseName().isEmpty()) {
                    if (someUpdates && session.isPlainTrace()) {
                        if (add) {
                            if (overrideExisting) {
                                session.out().printf("adding remote config (with override) %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                            } else {
                                session.out().printf("adding remote config %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                            }
                        } else if (overrideExisting) {
                            session.out().printf("updating remote config (with override) %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                        } else {
                            session.out().printf("updating remote config %s%n", new Object[]{factory.ofStyled(NdbUtils.coalesce(name.getConfigName(), "default"), NutsTextStyle.primary3())});
                        }
                    }
                } else {
                    RemoteMysqlDatabaseConfigService r = c.getDatabaseOrCreate(name.getDatabaseName());
                    if (forRemote_localName != null) {
                        someUpdates = true;
                        r.getConfig().setLocalName(forRemote_localName.toString());
                    }
                    if (forRemote_remoteName != null) {
                        someUpdates = true;
                        r.getConfig().setRemoteName(forRemote_remoteName.toString());
                    }
                    if (forRemote_server != null) {
                        someUpdates = true;
                        r.getConfig().setServer(forRemote_server);
                    }
                    if (someUpdates && session.isPlainTrace()) {
                        if (add) {
                            if (overrideExisting) {
                                session.out().printf("adding remote instance (with override) %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                            } else {
                                session.out().printf("adding remote instance %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                            }
                        } else if (overrideExisting) {
                            session.out().printf("updating remote instance (with override) %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                        } else {
                            session.out().printf("updating remote instance %s%n", new Object[]{factory.ofStyled(r.getFullName(), NutsTextStyle.primary3())});
                        }
                    }
                }
                if (!someUpdates) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nothing to save", (Object[])new Object[0]), 2);
                }
                c.saveConfig();
            }
        }
    }

    public void runRemove(NutsCommandLine commandLine, NMySqlService service) {
        Object v;
        Object c;
        commandLine.setCommandName("mysql remove");
        ArrayList<AtName> localNames = new ArrayList<AtName>();
        ArrayList<AtName> remoteNames = new ArrayList<AtName>();
        boolean currentLocal = true;
        block10: while (commandLine.hasNext()) {
            if (commandLine.peek().isOption()) {
                switch (commandLine.peek().getKey().getString()) {
                    case "--remote": {
                        commandLine.nextBoolean(new String[0]);
                        currentLocal = false;
                        continue block10;
                    }
                    case "--local": {
                        commandLine.nextBoolean(new String[0]);
                        currentLocal = true;
                        continue block10;
                    }
                    case "--name": {
                        if (currentLocal) {
                            localNames.add(AtName.nextAppOption(commandLine));
                            continue block10;
                        }
                        remoteNames.add(AtName.nextAppOption(commandLine));
                        continue block10;
                    }
                }
                service.getContext().configureLast(commandLine);
                continue;
            }
            if (currentLocal) {
                localNames.add(AtName.nextAppNonOption(commandLine));
                continue;
            }
            remoteNames.add(AtName.nextAppNonOption(commandLine));
        }
        if (localNames.isEmpty() && remoteNames.isEmpty()) {
            commandLine.required();
        }
        for (AtName localName : localNames) {
            if (localName.getDatabaseName().isEmpty()) {
                service.loadLocalMysqlConfig(localName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR).removeConfig();
                continue;
            }
            c = service.loadLocalMysqlConfig(localName.toString(), NutsOpenMode.OPEN_OR_NULL);
            if (c == null || (v = ((LocalMysqlConfigService)c).getDatabase(localName.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL)) == null) continue;
            ((LocalMysqlDatabaseConfigService)v).remove();
            ((LocalMysqlConfigService)c).saveConfig();
        }
        for (AtName remoteName : remoteNames) {
            if (remoteName.getDatabaseName().isEmpty()) {
                RemoteMysqlConfigService v2 = service.loadRemoteMysqlConfig(remoteName.getConfigName(), NutsOpenMode.OPEN_OR_NULL);
                if (v2 == null) continue;
                v2.removeConfig();
                continue;
            }
            c = service.loadRemoteMysqlConfig(remoteName.getConfigName(), NutsOpenMode.OPEN_OR_NULL);
            if (c == null || (v = ((RemoteMysqlConfigService)c).getDatabase(remoteName.getDatabaseName(), NutsOpenMode.OPEN_OR_NULL)) == null) continue;
            ((RemoteMysqlDatabaseConfigService)v).remove();
            ((RemoteMysqlConfigService)c).saveConfig();
        }
    }

    public Object toObject(String dbName, String confName, LocalMysqlDatabaseConfig config, boolean describe, boolean plain, NutsApplicationContext context) {
        NutsTexts text = NutsTexts.of((NutsSession)context.getSession());
        if (!describe) {
            if (plain) {
                return text.builder().append((Object)" [local ] ", NutsTextStyle.primary4()).append((Object)dbName).append((Object)"@").append((Object)confName, NutsTextStyle.primary4());
            }
            return new Object[]{"local", dbName, confName};
        }
        if (plain) {
            return text.builder().append((Object)" [local ] ", NutsTextStyle.primary4()).append((Object)dbName).append((Object)"@").append((Object)confName, NutsTextStyle.primary4()).append((Object)" db=").append((Object)config.getDatabaseName()).append((Object)" user=").append((Object)config.getUser());
        }
        return new Object[]{"local", dbName, confName, config.getUser()};
    }

    public Object toObject(String dbName, String confName, RemoteMysqlDatabaseConfig config, boolean describe, boolean plain, NutsApplicationContext context) {
        NutsTexts text = NutsTexts.of((NutsSession)context.getSession());
        if (!describe) {
            if (plain) {
                return text.builder().append((Object)" [remote] ", NutsTextStyle.primary4()).append((Object)dbName).append((Object)"@").append((Object)confName, NutsTextStyle.primary4());
            }
            return new Object[]{"remote", dbName, confName};
        }
        if (plain) {
            return text.builder().append((Object)" [remote] ", NutsTextStyle.primary4()).append((Object)dbName).append((Object)"@").append((Object)confName, NutsTextStyle.primary4()).append((Object)" local=").append((Object)config.getLocalName()).append((Object)" remote=").append((Object)config.getRemoteName()).append((Object)" on=").append((Object)config.getServer());
        }
        return new Object[]{"remote", dbName, confName, config.getLocalName(), config.getRemoteName(), config.getServer()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runList(NutsCommandLine commandLine, NMySqlService service, boolean describe) {
        NutsSession session;
        commandLine.setCommandName("mysql list");
        ArrayList<AtName> localNames = new ArrayList<AtName>();
        ArrayList<AtName> remoteNames = new ArrayList<AtName>();
        Boolean expectedLocal = null;
        block14: while (commandLine.hasNext()) {
            if (commandLine.peek().isOption()) {
                switch (commandLine.peek().getKey().getString()) {
                    case "--local": {
                        commandLine.nextBoolean(new String[0]);
                        expectedLocal = true;
                        continue block14;
                    }
                    case "--remote": {
                        commandLine.nextBoolean(new String[0]);
                        expectedLocal = false;
                        continue block14;
                    }
                }
                service.getContext().configureLast(commandLine);
                continue;
            }
            if (expectedLocal == null) {
                expectedLocal = true;
            }
            if (expectedLocal.booleanValue()) {
                localNames.add(AtName.nextConfigNonOption(commandLine));
                continue;
            }
            remoteNames.add(AtName.nextConfigNonOption(commandLine));
        }
        ArrayList<LocaleOrRemote> result = new ArrayList<LocaleOrRemote>();
        if (localNames.isEmpty() && remoteNames.isEmpty()) {
            if (expectedLocal == null || expectedLocal.booleanValue()) {
                for (LocalMysqlConfigService localMysqlConfigService : service.listLocalConfig()) {
                    result.add(new LocaleOrRemote(localMysqlConfigService.getName(), localMysqlConfigService.getConfig(), null));
                }
            }
            if (expectedLocal == null || !expectedLocal.booleanValue()) {
                for (RemoteMysqlConfigService remoteMysqlConfigService : service.listRemoteConfig()) {
                    result.add(new LocaleOrRemote(remoteMysqlConfigService.getName(), null, remoteMysqlConfigService.getConfig()));
                }
            }
        } else {
            Object c;
            for (AtName localName : localNames) {
                c = service.loadLocalMysqlConfig(localName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR);
                result.add(new LocaleOrRemote(((LocalMysqlConfigService)c).getName(), ((LocalMysqlConfigService)c).getConfig(), null));
            }
            for (AtName localName : remoteNames) {
                c = service.loadRemoteMysqlConfig(localName.getConfigName(), NutsOpenMode.OPEN_OR_ERROR);
                result.add(new LocaleOrRemote(((RemoteMysqlConfigService)c).getName(), null, ((RemoteMysqlConfigService)c).getConfig()));
            }
        }
        if ((session = service.getContext().getSession()).isIterableOut()) {
            long index = 0L;
            try {
                session.getIterableOutput().start();
                for (LocaleOrRemote localeOrRemote : result) {
                    if (localeOrRemote.local != null) {
                        for (Map.Entry<String, Object> entry : localeOrRemote.local.getDatabases().entrySet()) {
                            session.getIterableOutput().next(this.toObject(entry.getKey(), localeOrRemote.name, (LocalMysqlDatabaseConfig)entry.getValue(), describe, false, service.getContext()), index++);
                        }
                        continue;
                    }
                    for (Map.Entry<String, Object> entry : localeOrRemote.remote.getDatabases().entrySet()) {
                        session.getIterableOutput().next(this.toObject(entry.getKey(), localeOrRemote.name, (RemoteMysqlDatabaseConfig)entry.getValue(), describe, false, service.getContext()), index++);
                    }
                }
            }
            finally {
                session.getIterableOutput().complete(index);
            }
        }
        switch (session.getOutputFormat()) {
            case PLAIN: {
                for (LocaleOrRemote cnf : result) {
                    if (cnf.local != null) {
                        for (Map.Entry<String, LocalMysqlDatabaseConfig> entry : cnf.local.getDatabases().entrySet()) {
                            service.getContext().getSession().out().printf("%s%n", new Object[]{this.toObject(entry.getKey(), cnf.name, entry.getValue(), describe, true, service.getContext())});
                        }
                        continue;
                    }
                    for (Map.Entry<String, RemoteMysqlDatabaseConfig> entry : cnf.remote.getDatabases().entrySet()) {
                        service.getContext().getSession().out().printf("%s%n", new Object[]{this.toObject(entry.getKey(), cnf.name, entry.getValue(), describe, true, service.getContext())});
                    }
                }
                break;
            }
            default: {
                service.getContext().getSession().out().printlnf(result);
            }
        }
    }

    private static class LocaleOrRemote {
        String name;
        LocalMysqlConfig local;
        RemoteMysqlConfig remote;

        public LocaleOrRemote(String name, LocalMysqlConfig local, RemoteMysqlConfig remote) {
            this.name = name;
            this.local = local;
            this.remote = remote;
        }
    }
}

