/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql;

import java.util.logging.Logger;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUnsafeFunction;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlConfig;

public class NMySqlService {
    private static final Logger LOG = Logger.getLogger(NMySqlService.class.getName());
    private NutsApplicationContext context;
    private NutsPath sharedConfigFolder;

    public NMySqlService(NutsApplicationContext context) {
        this.context = context;
        this.sharedConfigFolder = context.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public LocalMysqlConfigService[] listLocalConfig() {
        return (LocalMysqlConfigService[])this.sharedConfigFolder.list().filter(pathname -> pathname.isRegularFile() && pathname.getName().toString().endsWith(".local-config"), "isRegularFile() && matches(*.local-config)").mapUnsafe(NutsUnsafeFunction.of(this::loadLocalMysqlConfig, (String)"loadLocalMysqlConfig"), null).filterNonNull().toArray(LocalMysqlConfigService[]::new);
    }

    public LocalMysqlConfigService loadLocalMysqlConfig(String name, NutsOpenMode action) {
        LocalMysqlConfigService t = new LocalMysqlConfigService(name, this.context);
        if (t.existsConfig()) {
            if (action == NutsOpenMode.CREATE_OR_ERROR) {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"local mysql config already exist: %s", (Object[])new Object[]{name}));
            }
            t.loadConfig();
        } else {
            switch (action) {
                case OPEN_OR_CREATE: {
                    t.setConfig(new LocalMysqlConfig());
                    break;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"no such local mysql config: %s", (Object[])new Object[]{name}));
                }
                case OPEN_OR_NULL: {
                    t = null;
                }
            }
        }
        return t;
    }

    public RemoteMysqlConfigService loadRemoteMysqlConfig(String name, NutsOpenMode action) {
        RemoteMysqlConfigService t = new RemoteMysqlConfigService(name, this.context);
        if (t.existsConfig()) {
            if (action == NutsOpenMode.CREATE_OR_ERROR) {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"remote mysql config already exist: %s", (Object[])new Object[]{name}));
            }
            t.loadConfig();
        } else {
            switch (action) {
                case OPEN_OR_CREATE: {
                    t.setConfig(new RemoteMysqlConfig());
                    break;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"no such remote mysql config: %s", (Object[])new Object[]{name}));
                }
                case OPEN_OR_NULL: {
                    t = null;
                    break;
                }
                case CREATE_OR_ERROR: {
                    t = null;
                }
            }
        }
        return t;
    }

    public LocalMysqlConfigService loadLocalMysqlConfig(NutsPath file) {
        LocalMysqlConfigService t = new LocalMysqlConfigService(file, this.context);
        t.loadConfig();
        return t;
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public RemoteMysqlConfigService loadRemoteMysqlConfig(String name) {
        RemoteMysqlConfigService t = new RemoteMysqlConfigService(name, this.context);
        t.loadConfig();
        return t;
    }

    public RemoteMysqlConfigService[] listRemoteConfig() {
        return (RemoteMysqlConfigService[])this.sharedConfigFolder.list().filter(pathname -> pathname.isRegularFile() && pathname.getName().toString().endsWith(".local-config"), "isRegularFile() && matches(*.local-config)").mapUnsafe(NutsUnsafeFunction.of(x -> {
            String nn = x.getName();
            return this.loadRemoteMysqlConfig(nn.substring(0, nn.length() - ".remote-config".length()));
        }, (String)"loadRemoteMysqlConfig"), null).filterNonNull().toArray(RemoteMysqlConfigService[]::new);
    }
}

