/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.derby;

import java.util.Objects;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsProcessInfo;
import net.thevpc.nuts.NutsSession;

public class RunningDerby {
    private String pid;
    private String home;
    private String argsLine;

    public RunningDerby(NutsProcessInfo r, NutsSession session) {
        this.pid = r.getPid();
        this.argsLine = r.getCommandLine();
        NutsCommandLine cmdline = NutsCommandLine.of((String)r.getCommandLine(), (NutsSession)session).setExpandSimpleOptions(false);
        NutsArgument a = null;
        while (cmdline.hasNext()) {
            a = cmdline.nextString(new String[]{"-Dderby.system.home"});
            if (a != null) {
                this.home = a.getValue().getString();
                continue;
            }
            cmdline.skip();
        }
    }

    public String getPid() {
        return this.pid;
    }

    public String getHome() {
        return this.home;
    }

    public String getArgsLine() {
        return this.argsLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningDerby that = (RunningDerby)o;
        return Objects.equals(this.pid, that.pid) && Objects.equals(this.home, that.home) && Objects.equals(this.argsLine, that.argsLine);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.home, this.argsLine);
    }

    public String toString() {
        return "RunningDerby{id='" + this.pid + '\'' + ", home='" + this.home + '\'' + ", argsLine='" + this.argsLine + '\'' + '}';
    }
}

