/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.derby;

import java.io.File;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ndb.NdbSupport;
import net.thevpc.nuts.toolbox.ndb.derby.Command;
import net.thevpc.nuts.toolbox.ndb.derby.DerbyOptions;
import net.thevpc.nuts.toolbox.ndb.derby.DerbyService;
import net.thevpc.nuts.toolbox.ndb.derby.DerbyUtils;
import net.thevpc.nuts.toolbox.ndb.derby.RunningDerby;
import net.thevpc.nuts.toolbox.ndb.derby.SSLMode;

public class NDerbyMain
implements NdbSupport {
    private NutsApplicationContext appContext;

    @Override
    public void run(NutsApplicationContext appContext, NutsCommandLine cmdLine) {
        this.appContext = appContext;
        NutsSession session = appContext.getSession();
        DerbyOptions options = new DerbyOptions();
        cmdLine.setCommandName("derby");
        while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.next(new String[]{"start"});
            if (a != null) {
                options.cmd = Command.start;
                continue;
            }
            a = cmdLine.next(new String[]{"sys", "sysinfo", "sys-info"});
            if (a != null) {
                options.cmd = Command.sysinfo;
                continue;
            }
            a = cmdLine.next(new String[]{"ping"});
            if (a != null) {
                options.cmd = Command.ping;
                continue;
            }
            a = cmdLine.next(new String[]{"status"});
            if (a != null) {
                this.status(cmdLine, options);
                return;
            }
            a = cmdLine.next(new String[]{"rt", "runtime", "runtimeinfo", "runtime-info"});
            if (a != null) {
                options.cmd = Command.runtimeinfo;
                continue;
            }
            a = cmdLine.nextString(new String[]{"trace"});
            if (a != null) {
                options.cmd = Command.trace;
                options.extraArg = a.getValue().getString();
                continue;
            }
            a = cmdLine.nextString(new String[]{"trace-directory", "tracedirectory"});
            if (a != null) {
                options.cmd = Command.tracedirectory;
                options.extraArg = a.getValue().getString();
                continue;
            }
            a = cmdLine.nextString(new String[]{"max-threads", "maxthreads"});
            if (a != null) {
                options.cmd = Command.maxthreads;
                options.extraArg = a.getValue().getString();
                continue;
            }
            a = cmdLine.nextString(new String[]{"time-slice", "timeslice"});
            if (a != null) {
                options.cmd = Command.timeslice;
                options.extraArg = a.getValue().getString();
                continue;
            }
            a = cmdLine.nextString(new String[]{"log-connections", "logconnections"});
            if (a != null) {
                options.cmd = Command.logconnections;
                options.extraArg = a.getValue().getString();
                continue;
            }
            a = cmdLine.next(new String[]{"stop", "shutdown"});
            if (a != null) {
                options.cmd = Command.shutdown;
                continue;
            }
            a = cmdLine.next(new String[]{"ps"});
            if (a != null) {
                this.ps(cmdLine, options);
                return;
            }
            a = cmdLine.next(new String[]{"versions"});
            if (a != null) {
                this.versions(cmdLine, options);
                return;
            }
            if (this._opt(cmdLine, options)) continue;
            cmdLine.setCommandName("derby").unexpectedArgument();
        }
        if (cmdLine.isExecMode()) {
            int effectivePort;
            DerbyService srv = new DerbyService(appContext);
            int n = effectivePort = options.port < 0 ? 1527 : options.port;
            if (options.cmd == Command.start) {
                NutsTexts factory = NutsTexts.of((NutsSession)session);
                if (cmdLine.isExecMode() && new DerbyService(appContext).isRunning()) {
                    session.out().printf("derby is %s on port %s%n", new Object[]{factory.ofStyled("already running", NutsTextStyle.warn()), factory.ofStyled("" + effectivePort, NutsTextStyle.number())});
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"derby is already running on port %d", (Object[])new Object[]{effectivePort}), 3);
                }
            } else if (options.cmd == Command.shutdown) {
                NutsTexts factory = NutsTexts.of((NutsSession)appContext.getSession());
                if (cmdLine.isExecMode() && !new DerbyService(appContext).isRunning()) {
                    session.out().printf("derby is %s on port %s%n", new Object[]{factory.ofStyled("already stopped", NutsTextStyle.warn()), factory.ofStyled("" + effectivePort, NutsTextStyle.number())});
                    session.out().printf("derby is %s%n", new Object[]{factory.ofStyled("already stopped", NutsTextStyle.warn())});
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"derby is already stopped on port %d", (Object[])new Object[]{effectivePort}), 3);
                }
            }
            srv.exec(options);
        }
    }

    public void status(NutsCommandLine cmdLine, DerbyOptions options) {
        cmdLine.setCommandName("tomcat --local status");
        while (cmdLine.hasNext()) {
            if (this._opt(cmdLine, options)) continue;
            cmdLine.unexpectedArgument();
        }
        options.cmd = Command.ping;
        NutsSession session = this.appContext.getSession();
        NutsTexts factory = NutsTexts.of((NutsSession)session);
        if (cmdLine.isExecMode()) {
            if (new DerbyService(this.appContext).isRunning()) {
                session.out().printf("derby is %s%n", new Object[]{factory.ofStyled("running", NutsTextStyle.primary1())});
            } else {
                session.out().printf("derby is %s%n", new Object[]{factory.ofStyled("stopped", NutsTextStyle.error())});
            }
        }
    }

    private boolean _opt(NutsCommandLine cmdLine, DerbyOptions options) {
        NutsArgument a = cmdLine.nextString(new String[]{"-v", "--derby-version"});
        if (a != null) {
            options.derbyVersion = a.getValue().getString();
            return true;
        }
        a = cmdLine.nextString(new String[]{"-d", "--db"});
        if (a != null) {
            options.derbyDataHomeRoot = a.getValue().getString();
            return true;
        }
        a = cmdLine.nextString(new String[]{"--nb"});
        if (a != null) {
            options.derbyDataHomeRoot = System.getProperty("user.home") + File.separator + ".netbeans-derby";
            return true;
        }
        a = cmdLine.nextString(new String[]{"-h", "--host"});
        if (a != null) {
            options.host = a.getValue().getString();
            return true;
        }
        a = cmdLine.nextString(new String[]{"-p", "--port"});
        if (a != null) {
            options.port = a.getValue().getInt();
            return true;
        }
        a = cmdLine.nextString(new String[]{"-ssl", "--ssl"});
        if (a != null) {
            options.sslmode = SSLMode.valueOf(a.getValue().getString());
            return true;
        }
        if (this.appContext.configureFirst(cmdLine)) {
            return true;
        }
        cmdLine.unexpectedArgument();
        return false;
    }

    public void ps(NutsCommandLine args, DerbyOptions options) {
        String format = "default";
        args.setCommandName("tomcat --local ps");
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"-l", "--long"});
            if (a != null) {
                format = "long";
                continue;
            }
            a = args.nextBoolean(new String[]{"-s", "--short"});
            if (a != null) {
                format = "short";
                continue;
            }
            if (this._opt(args, options)) continue;
            args.unexpectedArgument();
        }
        NutsSession session = this.appContext.getSession();
        NutsTexts factory = NutsTexts.of((NutsSession)session);
        if (args.isExecMode()) {
            if (session.isPlainOut()) {
                NutsPrintStream out = session.out();
                block9: for (RunningDerby jpsResult : DerbyUtils.getRunningInstances(this.appContext)) {
                    switch (format) {
                        case "short": {
                            out.printf("%s\n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1())});
                            continue block9;
                        }
                        case "long": {
                            out.printf("%s %s %s %s %s%n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1()), factory.ofPlain("HOME:"), factory.ofStyled(jpsResult.getHome(), NutsTextStyle.path()), factory.ofPlain("CMD:"), this.appContext.getCommandLine().parseLine(jpsResult.getArgsLine()).format()});
                            continue block9;
                        }
                        default: {
                            out.printf("%s %s\n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1()), jpsResult.getHome()});
                        }
                    }
                }
            } else {
                session.out().printlnf((Object)DerbyUtils.getRunningInstances(this.appContext));
            }
        }
    }

    public void versions(NutsCommandLine args, DerbyOptions options) {
        args.setCommandName("tomcat --local versions");
        while (args.hasNext()) {
            if (this._opt(args, options)) continue;
            args.unexpectedArgument();
        }
        if (args.isExecMode()) {
            DerbyService srv = new DerbyService(this.appContext);
            this.appContext.getSession().out().printlnf(srv.findVersions());
        }
    }
}

