/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.derby;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsVersionFilters;
import net.thevpc.nuts.toolbox.ndb.derby.Command;
import net.thevpc.nuts.toolbox.ndb.derby.DerbyOptions;
import net.thevpc.nuts.toolbox.ndb.derby.DerbyUtils;
import net.thevpc.nuts.toolbox.ndb.derby.NDerbyMain;

public class DerbyService {
    NutsApplicationContext appContext;
    NutsLogger LOG;

    public DerbyService(NutsApplicationContext appContext) {
        this.appContext = appContext;
        this.LOG = NutsLogger.of(this.getClass(), (NutsSession)appContext.getSession());
    }

    public boolean isRunning() {
        DerbyOptions options = new DerbyOptions();
        options.cmd = Command.ping;
        try {
            String s = this.command(options).setFailFast(true).grabOutputString().getOutputString();
            if (s != null) {
                return true;
            }
        }
        catch (NutsExecutionException nutsExecutionException) {
            // empty catch block
        }
        return false;
    }

    public static String getAbsoluteFile(String path, String cwd) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (cwd == null) {
            cwd = System.getProperty("user.dir");
        }
        switch (path) {
            case "~": {
                return System.getProperty("user.home");
            }
            case ".": {
                File file = new File(cwd);
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
            case "..": {
                File file = new File(cwd, "..");
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
        }
        int j = -1;
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' && chars[i] != '\\') continue;
            j = i;
            break;
        }
        if (j > 0) {
            switch (path.substring(0, j)) {
                case "~": {
                    String e = path.substring(j + 1);
                    if (e.isEmpty()) {
                        return System.getProperty("user.home");
                    }
                    File file = new File(System.getProperty("user.home"), e);
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        return file.getAbsolutePath();
                    }
                }
            }
        }
        File file = new File(cwd, path);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    private Path download(String id, Path folder, boolean optional) {
        NutsId iid = NutsId.of((String)id, (NutsSession)this.appContext.getSession());
        Path targetFile = folder.resolve(iid.getArtifactId() + ".jar");
        if (!Files.exists(targetFile, new LinkOption[0])) {
            if (optional) {
                Path r = this.appContext.getSession().fetch().setLocation(targetFile).setId(id).setFailFast(false).getResultPath();
                if (r != null) {
                    this.LOG.with().session(this.appContext.getSession()).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"downloading {0} to {1}", (Object[])new Object[]{id, targetFile}));
                }
            } else {
                this.appContext.getSession().fetch().setLocation(targetFile).setId(id).setFailFast(true).getResultPath();
                this.LOG.with().session(this.appContext.getSession()).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"downloading {0} to {1}", (Object[])new Object[]{id, targetFile}));
            }
        } else {
            this.LOG.with().session(this.appContext.getSession()).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"using {0} form {1}", (Object[])new Object[]{id, targetFile}));
        }
        return targetFile;
    }

    public Set<String> findVersions() {
        NutsSession session = this.appContext.getSession();
        NutsId java = session.env().getPlatform();
        List all = session.search().setSession(this.appContext.getSession().copy()).addId("org.apache.derby:derbynet").setDistinct(true).setIdFilter(java.getVersion().compareTo("1.9") < 0 ? (NutsIdFilter)NutsVersionFilters.of((NutsSession)session).byValue("[,10.15.1.3[").to(NutsIdFilter.class) : null).getResultIds().stream().map(x -> x.getVersion().toString()).collect(Collectors.toList());
        TreeSet<String> lastFirst = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        lastFirst.addAll(all);
        return lastFirst;
    }

    public NutsExecCommand command(DerbyOptions options) {
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> executorOptions = new ArrayList<String>();
        NutsSession session = this.appContext.getSession();
        String currentDerbyVersion = options.derbyVersion;
        if (currentDerbyVersion == null) {
            NutsId java = session.env().getPlatform();
            NutsId best = (NutsId)session.search().setSession(this.appContext.getSession().copy()).addId("org.apache.derby:derbynet").setDistinct(true).setLatest(true).setIdFilter(java.getVersion().compareTo("1.9") < 0 ? (NutsIdFilter)NutsVersionFilters.of((NutsSession)session).byValue("[,10.15.1.3[").to(NutsIdFilter.class) : null).setSession(this.appContext.getSession().copy()).getResultIds().singleton();
            currentDerbyVersion = best.getVersion().toString();
        }
        NutsPath derbyDataHome = null;
        derbyDataHome = options.derbyDataHomeReplace != null ? this.appContext.getSharedVarFolder() : (options.derbyDataHomeRoot != null && options.derbyDataHomeRoot.trim().length() > 0 ? NutsPath.of((String)options.derbyDataHomeRoot, (NutsSession)session).toAbsolute(this.appContext.getSharedVarFolder()) : this.appContext.getSharedVarFolder().resolve("derby-db"));
        NutsPath derbyDataHomeRoot = derbyDataHome.getParent();
        derbyDataHome.mkdirs();
        Path derbyBinHome = session.locations().getStoreLocation(this.appContext.getAppId(), NutsStoreLocation.APPS).resolve(currentDerbyVersion).toFile();
        Path derbyLibHome = derbyBinHome.resolve("lib");
        Path derby = this.download("org.apache.derby:derby#" + currentDerbyVersion, derbyLibHome, false);
        Path derbynet = this.download("org.apache.derby:derbynet#" + currentDerbyVersion, derbyLibHome, false);
        Path derbyoptionaltools = this.download("org.apache.derby:derbyoptionaltools#" + currentDerbyVersion, derbyLibHome, true);
        Path derbyclient = this.download("org.apache.derby:derbyclient#" + currentDerbyVersion, derbyLibHome, false);
        Path derbytools = this.download("org.apache.derby:derbytools#" + currentDerbyVersion, derbyLibHome, false);
        Path policy = derbyBinHome.resolve("derby.policy");
        if (!Files.exists(policy, new LinkOption[0]) || this.appContext.getSession().isYes()) {
            try (InputStream is = NDerbyMain.class.getResourceAsStream("/net/thevpc/nuts/toolbox/ndb/derby/policy-file.policy");){
                String permissions = new String(DerbyUtils.loadByteArray(is)).replace("${{DB_PATH}}", derbyDataHomeRoot.toString());
                Files.write(policy, permissions.getBytes(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new NutsExecutionException(this.appContext.getSession(), NutsMessage.cstyle((String)"unable to create %s", (Object[])new Object[]{policy}), 1);
            }
        }
        command.add("org.apache.derby:derbytools#" + currentDerbyVersion);
        executorOptions.add("-Djava.security.manager");
        executorOptions.add("-Djava.security.policy=" + policy.toString());
        executorOptions.add("--classpath=" + derby + ":" + derbynet + ":" + derbyclient + ":" + derbytools + (derbyoptionaltools != null ? ":" + derbyoptionaltools : ""));
        executorOptions.add("--main-class=org.apache.derby.drda.NetworkServerControl");
        executorOptions.add("-Dderby.system.home=" + derbyDataHome.toString());
        if (options.host != null) {
            command.add("-h");
            command.add(options.host);
        }
        if (options.port != -1) {
            command.add("-p");
            command.add(String.valueOf(options.port));
        }
        if (options.sslmode != null) {
            command.add("-ssl");
            command.add(String.valueOf((Object)options.sslmode));
        }
        command.add(options.cmd.toString());
        if (options.extraArg != null) {
            command.add(options.extraArg);
        }
        return session.exec().addExecutorOptions(executorOptions).addCommand(command).setDirectory(derbyBinHome.toString()).setFailFast(true);
    }

    void exec(DerbyOptions options) {
        NutsExecCommand cmd = this.command(options);
        boolean[] finished = new boolean[1];
        Thread t = new Thread(() -> {
            try {
                cmd.run();
            }
            finally {
                finished[0] = true;
            }
        }, "Derby");
        t.setDaemon(true);
        t.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

