/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlDatabaseConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.MysqlUtils;

public class RemoteMysqlConfigService {
    public static final String CLIENT_CONFIG_EXT = ".remote-config";
    RemoteMysqlConfig config;
    NutsApplicationContext context;
    Path sharedConfigFolder;
    private String name;

    public RemoteMysqlConfigService(String name, NutsApplicationContext context) {
        this.setName(name);
        this.context = context;
        this.sharedConfigFolder = Paths.get(context.getVersionFolderFolder(NutsStoreLocation.CONFIG, "0.8.0.0"), new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public RemoteMysqlConfigService setName(String name) {
        this.name = MysqlUtils.toValidFileName(name, "default");
        return this;
    }

    public RemoteMysqlConfig getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public RemoteMysqlConfigService setConfig(RemoteMysqlConfig config) {
        this.config = config;
        return this;
    }

    public RemoteMysqlConfigService saveConfig() {
        Path f = this.getConfigPath();
        this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)this.config).print(f);
        return this;
    }

    private Path getConfigPath() {
        return this.sharedConfigFolder.resolve(this.name + CLIENT_CONFIG_EXT);
    }

    public boolean existsConfig() {
        Path f = this.getConfigPath();
        return Files.exists(f, new LinkOption[0]);
    }

    public RemoteMysqlConfigService loadConfig() {
        if (this.name == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"missing config name", (Object[])new Object[0]), 2);
        }
        Path f = this.getConfigPath();
        if (Files.exists(f, new LinkOption[0])) {
            this.config = (RemoteMysqlConfig)this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(f, RemoteMysqlConfig.class);
            return this;
        }
        throw new NoSuchElementException("config not found : " + this.name);
    }

    public RemoteMysqlConfigService removeConfig() {
        Path f = this.getConfigPath();
        try {
            Files.delete(f);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this;
    }

    public RemoteMysqlConfigService write(PrintStream out) {
        this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)this.getConfig()).print((OutputStream)out);
        out.flush();
        return this;
    }

    public RemoteMysqlDatabaseConfigService getDatabaseOrCreate(String appName) {
        RemoteMysqlDatabaseConfig a = this.getConfig().getDatabases().get(appName);
        if (a == null) {
            a = new RemoteMysqlDatabaseConfig();
            this.getConfig().getDatabases().put(appName, a);
        }
        return new RemoteMysqlDatabaseConfigService(appName, a, this);
    }

    public RemoteMysqlDatabaseConfigService getDatabase(String dbName, NutsOpenMode action) {
        dbName = MysqlUtils.toValidFileName(dbName, "default");
        RemoteMysqlDatabaseConfig a = this.getConfig().getDatabases().get(dbName);
        if (a == null) {
            switch (action) {
                case OPEN_OR_NULL: {
                    return null;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"remote instance not found: %s@%s", (Object[])new Object[]{dbName, this.getName()}));
                }
                case CREATE_OR_ERROR: 
                case OPEN_OR_CREATE: {
                    a = new RemoteMysqlDatabaseConfig();
                    this.getConfig().getDatabases().put(dbName, a);
                    return new RemoteMysqlDatabaseConfigService(dbName, a, this);
                }
            }
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"unexpected error", (Object[])new Object[0]));
        }
        switch (action) {
            case CREATE_OR_ERROR: {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"remote instance not found: %s@%s", (Object[])new Object[]{dbName, this.getName()}));
            }
            case OPEN_OR_NULL: 
            case OPEN_OR_ERROR: 
            case OPEN_OR_CREATE: {
                return new RemoteMysqlDatabaseConfigService(dbName, a, this);
            }
        }
        throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"unexpected error", (Object[])new Object[0]));
    }

    public List<RemoteMysqlDatabaseConfigService> getDatabases() {
        ArrayList<RemoteMysqlDatabaseConfigService> a = new ArrayList<RemoteMysqlDatabaseConfigService>();
        for (String s : this.getConfig().getDatabases().keySet()) {
            a.add(new RemoteMysqlDatabaseConfigService(s, this.getConfig().getDatabases().get(s), this));
        }
        return a;
    }
}

