/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.remote;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsId;

public class CachedMapFile {
    private NutsApplicationContext context;
    private Map<String, String> map;
    private boolean enabled;
    private Path path;
    private boolean loaded;

    public CachedMapFile(NutsApplicationContext context, String name) {
        this(context, name, true);
    }

    public CachedMapFile(NutsApplicationContext context, String name, boolean enabled) {
        this.context = context;
        this.enabled = enabled;
        NutsId appId = context.getAppId();
        this.path = Paths.get(context.getTempFolder(), new String[0]).resolve(appId.getGroupId() + "-" + appId.getArtifactId() + "-" + appId.getVersion()).resolve(name + ".json");
        if (enabled && Files.isRegularFile(this.path, new LinkOption[0])) {
            try {
                this.map = (Map)context.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(this.path, Map.class);
                this.loaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public CachedMapFile setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean exists() {
        return this.loaded;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean contains(String k) {
        if (!this.enabled) {
            return false;
        }
        if (this.map == null) {
            return false;
        }
        return this.map.get(k) != null;
    }

    public String get(String k) {
        if (!this.enabled) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        return this.map.get(k);
    }

    public boolean is(String k) {
        return "true".equals(this.get(k));
    }

    public void put(String k) {
        this.put("k", "true");
    }

    public void put(String k, String v) {
        if (this.enabled) {
            if (this.map == null) {
                this.map = new HashMap<String, String>();
            }
            this.map.put(k, v);
            try {
                this.context.getWorkspace().elem().setValue(this.map).setContentType(NutsContentType.JSON).print(this.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.dispose();
        this.map = null;
    }

    public void dispose() {
        if (this.path != null) {
            try {
                Files.delete(this.path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

