/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlDatabaseConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.util.MysqlUtils;
import net.thevpc.nuts.toolbox.ndb.util.NdbUtils;

public class LocalMysqlConfigService {
    public static final String SERVER_CONFIG_EXT = ".local-config";
    private String name;
    private LocalMysqlConfig config;
    private NutsApplicationContext context;
    private NutsDefinition catalinaNutsDefinition;
    private String catalinaVersion;
    private Path sharedConfigFolder;

    public LocalMysqlConfigService(Path file, NutsApplicationContext context) {
        this(file.getFileName().toString().substring(0, file.getFileName().toString().length() - SERVER_CONFIG_EXT.length()), context);
        this.loadConfig();
    }

    public LocalMysqlConfigService(String name, NutsApplicationContext context) {
        this.setName(name);
        this.context = context;
        this.sharedConfigFolder = Paths.get(this.getContext().getVersionFolderFolder(NutsStoreLocation.CONFIG, "0.8.0.0"), new String[0]);
    }

    public LocalMysqlConfigService setName(String name) {
        this.name = MysqlUtils.toValidFileName(name, "default");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public LocalMysqlConfig getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    public LocalMysqlConfigService saveConfig() {
        Path f = this.getServerConfigPath();
        this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)this.config).print(f);
        return this;
    }

    public boolean existsConfig() {
        Path f = this.getServerConfigPath();
        return Files.exists(f, new LinkOption[0]);
    }

    private Path getServerConfigPath() {
        return this.sharedConfigFolder.resolve(this.getName() + SERVER_CONFIG_EXT);
    }

    public String[] parseApps(String[] args) {
        ArrayList<String> apps = new ArrayList<String>();
        if (args != null) {
            for (String arg : args) {
                if (NdbUtils.isBlank(arg)) continue;
                for (String s : arg.split("[, ]")) {
                    if (s.isEmpty()) continue;
                    apps.add(s);
                }
            }
        }
        return apps.toArray(new String[0]);
    }

    public LocalMysqlConfigService loadConfig() {
        String name = this.getName();
        Path f = this.getServerConfigPath();
        if (Files.exists(f, new LinkOption[0])) {
            this.config = (LocalMysqlConfig)this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(f, LocalMysqlConfig.class);
            return this;
        }
        if ("default".equals(name)) {
            this.config = new LocalMysqlConfig();
            this.saveConfig();
            return this;
        }
        throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"no such mysql config : %s", (Object[])new Object[]{name}));
    }

    public LocalMysqlConfigService removeConfig() {
        try {
            Files.delete(this.getServerConfigPath());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this;
    }

    public LocalMysqlConfigService write(PrintStream out) {
        this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)this.getConfig()).print((OutputStream)out);
        return this;
    }

    public LocalMysqlConfigService setConfig(LocalMysqlConfig config) {
        this.config = config;
        return this;
    }

    public LocalMysqlDatabaseConfigService getDatabase(String dbName, NutsOpenMode action) {
        dbName = MysqlUtils.toValidFileName(dbName, "default");
        LocalMysqlDatabaseConfig a = this.getConfig().getDatabases().get(dbName);
        if (a == null) {
            switch (action) {
                case OPEN_OR_NULL: {
                    return null;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"local instance not found:%s@%s", (Object[])new Object[]{dbName, this.getName()}));
                }
                case CREATE_OR_ERROR: 
                case OPEN_OR_CREATE: {
                    a = new LocalMysqlDatabaseConfig();
                    this.getConfig().getDatabases().put(dbName, a);
                    return new LocalMysqlDatabaseConfigService(dbName, a, this);
                }
            }
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"unexpected error", (Object[])new Object[0]));
        }
        switch (action) {
            case CREATE_OR_ERROR: {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"local instance not found:%s@%s", (Object[])new Object[]{dbName, this.getName()}));
            }
            case OPEN_OR_NULL: 
            case OPEN_OR_ERROR: 
            case OPEN_OR_CREATE: {
                return new LocalMysqlDatabaseConfigService(dbName, a, this);
            }
        }
        throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"unexpected error", (Object[])new Object[0]));
    }

    public List<LocalMysqlDatabaseConfigService> getDatabases() {
        ArrayList<LocalMysqlDatabaseConfigService> a = new ArrayList<LocalMysqlDatabaseConfigService>();
        for (String s : this.getConfig().getDatabases().keySet()) {
            a.add(new LocalMysqlDatabaseConfigService(s, this.getConfig().getDatabases().get(s), this));
        }
        return a;
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public String getMysqlCommand() {
        String s = this.getConfig().getMysqlCommand();
        if (NdbUtils.isBlank(s)) {
            s = "mysql";
        }
        return s;
    }

    public String getMysqldumpCommand() {
        String s = this.getConfig().getMysqldumpCommand();
        if (NdbUtils.isBlank(s)) {
            s = "mysqldump";
        }
        return s;
    }
}

