/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql.local;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlDatabaseConfig;
import net.thevpc.nuts.toolbox.ndb.util.NdbUtils;

public class LocalMysqlDatabaseConfigService {
    private String name;
    private LocalMysqlDatabaseConfig config;
    private LocalMysqlConfigService mysql;
    private NutsApplicationContext context;

    public LocalMysqlDatabaseConfigService(String name, LocalMysqlDatabaseConfig config, LocalMysqlConfigService mysql) {
        this.name = name;
        this.config = config;
        this.mysql = mysql;
        this.context = mysql.getContext();
    }

    public LocalMysqlDatabaseConfig getConfig() {
        return this.config;
    }

    public LocalMysqlConfigService getMysql() {
        return this.mysql;
    }

    public LocalMysqlDatabaseConfigService remove() {
        this.mysql.getConfig().getDatabases().remove(this.name);
        this.context.getSession().out().printf("%s app removed.%n", new Object[]{this.getBracketsPrefix(this.getFullName())});
        return this;
    }

    public NutsString getBracketsPrefix(String str) {
        return this.context.getWorkspace().text().builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    public String getFullName() {
        return this.getName() + "@" + this.mysql.getName();
    }

    public String getName() {
        return this.name;
    }

    public LocalMysqlDatabaseConfigService write(PrintStream out) {
        this.context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)this.getConfig()).print((OutputStream)out);
        return this;
    }

    public ArchiveResult backup(String path) {
        int result;
        if (NdbUtils.isBlank(path)) {
            String databaseName = this.getConfig().getDatabaseName();
            if (NdbUtils.isBlank(databaseName)) {
                databaseName = this.name;
            }
            path = databaseName + "-" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".sql.zip";
        }
        if (!(path.endsWith(".sql.zip") || path.endsWith(".zip") || path.endsWith(".sql"))) {
            path = path + ".sql.zip";
        }
        path = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        String password = this.getConfig().getPassword();
        char[] credentials = this.context.getWorkspace().security().getCredentials(password.toCharArray());
        password = new String(credentials);
        if (path.endsWith(".sql")) {
            NutsExecCommand cmd;
            int result2;
            if (this.context.getSession().isPlainTrace()) {
                this.context.getSession().out().printf("%s create archive %s%n", new Object[]{this.getDatabaseName(), path});
            }
            if ((result2 = (cmd = this.context.getWorkspace().exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"sh", "-c", "\"" + this.mysql.getMysqldumpCommand() + "\" -u \"$CMD_USER\" -p\"$CMD_PWD\" --databases \"$CMD_DB\" > \"$CMD_FILE\""}).setEnv("CMD_FILE", path).setEnv("CMD_USER", this.getConfig().getUser()).setEnv("CMD_PWD", password).setEnv("CMD_DB", this.getDatabaseName()).grabOutputString().setRedirectErrorStream(true)).getResult()) == 0) {
                return new ArchiveResult(path, result2, false);
            }
            if (new File(path).exists()) {
                new File(path).delete();
            }
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.formatted((String)cmd.getOutputString()), 2);
        }
        if (this.context.getSession().isPlainTrace()) {
            this.context.getSession().out().printf("%s create archive %s%n", new Object[]{this.getBracketsPrefix(this.getDatabaseName()), this.context.getWorkspace().text().forStyled(path, NutsTextStyle.path())});
        }
        NutsExecCommand cmd = this.context.getWorkspace().exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"sh", "-c", "set -o pipefail && \"" + this.mysql.getMysqldumpCommand() + "\" -u \"$CMD_USER\" -p" + password + " --databases \"$CMD_DB\" | gzip > \"$CMD_FILE\""}).setEnv("CMD_FILE", path).setEnv("CMD_USER", this.getConfig().getUser()).setEnv("CMD_PWD", password).setEnv("CMD_DB", this.getDatabaseName()).grabOutputString().setRedirectErrorStream(true);
        if (this.context.getSession().isPlainTrace()) {
            this.context.getSession().out().printf("%s    [EXEC] %s%n", new Object[]{this.getBracketsPrefix(this.getDatabaseName()), cmd.formatter().setEnvReplacer(envEntry -> {
                if ("CMD_PWD".equals(envEntry.getName())) {
                    return "****";
                }
                return null;
            }).format()});
        }
        if ((result = cmd.getResult()) == 0) {
            return new ArchiveResult(path, result, false);
        }
        if (new File(path).exists()) {
            new File(path).delete();
        }
        throw new NutsExecutionException(this.context.getSession(), NutsMessage.formatted((String)cmd.getOutputString()), 2);
    }

    public RestoreResult restore(String path) {
        char[] password = this.context.getWorkspace().security().getCredentials(this.getConfig().getPassword().toCharArray());
        if (path.endsWith(".sql")) {
            if (this.context.getSession().isPlainTrace()) {
                this.context.getSession().out().printf("%s restore archive %s%n", new Object[]{this.getBracketsPrefix(this.getDatabaseName()), path});
            }
            int result = this.context.getWorkspace().exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"sh", "-c", "cat \"$CMD_FILE\" | \"" + this.mysql.getMysqlCommand() + "\" -h \"$CMD_HOST\" -u \"$CMD_USER\" \"-p$CMD_PWD\" \"$CMD_DB\""}).setEnv("CMD_FILE", path).setEnv("CMD_USER", this.getConfig().getUser()).setEnv("CMD_PWD", new String(password)).setEnv("CMD_DB", this.getDatabaseName()).setEnv("CMD_HOST", "localhost").getResult();
            return new RestoreResult(path, result, false);
        }
        if (this.context.getSession().isPlainTrace()) {
            this.context.getSession().out().printf("%s restore archive %s%n", new Object[]{this.getBracketsPrefix(this.getDatabaseName()), path});
        }
        int result = this.context.getWorkspace().exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"sh", "-c", "gunzip -c \"$CMD_FILE\" | \"" + this.mysql.getMysqlCommand() + "\" -h \"$CMD_HOST\" -u \"$CMD_USER\" \"-p$CMD_PWD\" \"$CMD_DB\""}).setEnv("CMD_FILE", path).setEnv("CMD_USER", this.getConfig().getUser()).setEnv("CMD_PWD", new String(password)).setEnv("CMD_DB", this.getDatabaseName()).setEnv("CMD_HOST", "localhost").getResult();
        return new RestoreResult(path, result, true);
    }

    public String getDatabaseName() {
        String s = this.getConfig().getDatabaseName();
        if (NdbUtils.isBlank(s)) {
            s = this.name;
        }
        return s;
    }

    public static class RestoreResult {
        public String path;
        public int execResult;
        public boolean zip;

        public RestoreResult(String path, int execResult, boolean zip) {
            this.path = path;
            this.execResult = execResult;
            this.zip = zip;
        }
    }

    public static class ArchiveResult {
        public String path;
        public int execResult;
        public boolean zip;

        public ArchiveResult(String path, int execResult, boolean zip) {
            this.path = path;
            this.execResult = execResult;
            this.zip = zip;
        }
    }
}

