/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ndb.nmysql;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.LocalMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.local.config.LocalMysqlConfig;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.RemoteMysqlConfigService;
import net.thevpc.nuts.toolbox.ndb.nmysql.remote.config.RemoteMysqlConfig;

public class NMySqlService {
    private static final Logger LOG = Logger.getLogger(NMySqlService.class.getName());
    private NutsApplicationContext context;
    private Path sharedConfigFolder;

    public NMySqlService(NutsApplicationContext context) {
        this.context = context;
        this.sharedConfigFolder = Paths.get(context.getVersionFolderFolder(NutsStoreLocation.CONFIG, "0.8.0.0"), new String[0]);
    }

    public LocalMysqlConfigService[] listLocalConfig() {
        ArrayList<LocalMysqlConfigService> all = new ArrayList<LocalMysqlConfigService>();
        if (Files.isDirectory(this.sharedConfigFolder, new LinkOption[0])) {
            try (DirectoryStream<Path> configFiles = Files.newDirectoryStream(this.sharedConfigFolder, pathname -> pathname.getFileName().toString().endsWith(".local-config"));){
                for (Path file1 : configFiles) {
                    try {
                        LocalMysqlConfigService c = this.loadLocalMysqlConfig(file1);
                        all.add(c);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.FINE, "Error loading config url : " + file1, ex);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return all.toArray(new LocalMysqlConfigService[0]);
    }

    public LocalMysqlConfigService loadLocalMysqlConfig(String name, NutsOpenMode action) {
        LocalMysqlConfigService t = new LocalMysqlConfigService(name, this.context);
        if (t.existsConfig()) {
            if (action == NutsOpenMode.CREATE_OR_ERROR) {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"local mysql config already exist: %s", (Object[])new Object[]{name}));
            }
            t.loadConfig();
        } else {
            switch (action) {
                case OPEN_OR_CREATE: {
                    t.setConfig(new LocalMysqlConfig());
                    break;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"no such local mysql config: %s", (Object[])new Object[]{name}));
                }
                case OPEN_OR_NULL: {
                    t = null;
                }
            }
        }
        return t;
    }

    public RemoteMysqlConfigService loadRemoteMysqlConfig(String name, NutsOpenMode action) {
        RemoteMysqlConfigService t = new RemoteMysqlConfigService(name, this.context);
        if (t.existsConfig()) {
            if (action == NutsOpenMode.CREATE_OR_ERROR) {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"remote mysql config already exist: %s", (Object[])new Object[]{name}));
            }
            t.loadConfig();
        } else {
            switch (action) {
                case OPEN_OR_CREATE: {
                    t.setConfig(new RemoteMysqlConfig());
                    break;
                }
                case OPEN_OR_ERROR: {
                    throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"no such remote mysql config: %s", (Object[])new Object[]{name}));
                }
                case OPEN_OR_NULL: {
                    t = null;
                    break;
                }
                case CREATE_OR_ERROR: {
                    t = null;
                }
            }
        }
        return t;
    }

    public LocalMysqlConfigService loadLocalMysqlConfig(Path file) {
        LocalMysqlConfigService t = new LocalMysqlConfigService(file, this.context);
        t.loadConfig();
        return t;
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public RemoteMysqlConfigService loadRemoteMysqlConfig(String name) {
        RemoteMysqlConfigService t = new RemoteMysqlConfigService(name, this.context);
        t.loadConfig();
        return t;
    }

    public RemoteMysqlConfigService[] listRemoteConfig() {
        ArrayList<RemoteMysqlConfigService> all = new ArrayList<RemoteMysqlConfigService>();
        if (Files.isDirectory(this.sharedConfigFolder, new LinkOption[0])) {
            try (DirectoryStream<Path> configFiles = Files.newDirectoryStream(this.sharedConfigFolder, x -> x.getFileName().toString().endsWith(".remote-config"));){
                for (Path file1 : configFiles) {
                    try {
                        String nn = file1.getFileName().toString();
                        RemoteMysqlConfigService c = this.loadRemoteMysqlConfig(nn.substring(0, nn.length() - ".remote-config".length()));
                        all.add(c);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return all.toArray(new RemoteMysqlConfigService[0]);
    }
}

