/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.sources;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.sources.SourceAdapter;
import net.thevpc.nuts.toolbox.ncode.sources.SourceFactory;
import net.thevpc.nuts.toolbox.ncode.sources.ZipEntrySource;

public class ZipSource
extends SourceAdapter {
    private static Logger LOG = Logger.getLogger(ZipSource.class.getName());

    public ZipSource(Source source) {
        super(source);
    }

    @Override
    public Iterable<Source> getChildren() {
        return new ZipIterable();
    }

    protected ZipEntrySource createZipSource(ZipEntry nextEntry, ZipInputStream zip) {
        return new ZipEntrySource(nextEntry, zip, this.getSource().getExternalPath());
    }

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new ZipInputStream(this.getSource().openStream());
    }

    @Override
    public String toString() {
        return "ZipSource{" + super.toString() + "}";
    }

    private class ZipIterator
    implements Iterator<Source>,
    Closeable {
        InputStream in;
        JarInputStream zip = null;
        ZipEntry nextEntry = null;

        public ZipIterator(InputStream in) {
            this.in = in;
            try {
                this.zip = in == null ? null : new JarInputStream(in);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error creating input stream", ex);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.zip != null) {
                try {
                    this.nextEntry = this.zip.getNextEntry();
                    if (this.nextEntry == null) {
                        this.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(ZipSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.nextEntry = null;
            }
            return this.nextEntry != null;
        }

        @Override
        public void close() {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Source next() {
            return SourceFactory.wrap(ZipSource.this.createZipSource(this.nextEntry, this.zip));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class ZipIterable
    implements Iterable<Source> {
        private ZipIterable() {
        }

        @Override
        public Iterator<Source> iterator() {
            try {
                return new ZipIterator(ZipSource.this.getSource().openStream());
            }
            catch (IOException ex) {
                return new ZipIterator(null);
            }
        }
    }
}

