/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.sources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.bundles._Utils;

public class ZipEntrySource
implements Source {
    private boolean stream;
    private boolean directory;
    private String name;
    private String prefixPath;
    private String internalPath;
    private ZipEntry entry;
    private ZipInputStream zip;
    private byte[] bytes;

    public ZipEntrySource(ZipEntry entry, ZipInputStream zip, String prefixPath) {
        this.stream = !entry.getName().endsWith("/");
        this.directory = !this.stream;
        this.entry = entry;
        this.name = new File(entry.getName()).getName();
        this.internalPath = entry.getName();
        this.prefixPath = prefixPath;
        this.zip = zip;
    }

    public String toString() {
        return "ZipEntrySource{" + this.entry.getName() + "}";
    }

    @Override
    public boolean isStream() {
        return this.stream;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExternalPath() {
        return this.prefixPath + ":" + this.internalPath;
    }

    @Override
    public String getInternalPath() {
        return this.internalPath;
    }

    @Override
    public boolean isFolder() {
        return this.directory;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.bytes == null) {
            this.bytes = _Utils.toByteArray(this.zip);
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Iterable<Source> getChildren() {
        return Collections.EMPTY_LIST;
    }
}

