/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.sources;

import java.io.File;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.sources.FileSource;
import net.thevpc.nuts.toolbox.ncode.sources.FolderSource;
import net.thevpc.nuts.toolbox.ncode.sources.JavaTypeSource;
import net.thevpc.nuts.toolbox.ncode.sources.ZipSource;

public class SourceFactory {
    public static Source wrap(Source src) {
        if (!src.isStream()) {
            return src;
        }
        String name = src.getName().toLowerCase();
        if (name.endsWith(".zip") || name.endsWith(".jar")) {
            return new ZipSource(src);
        }
        if (name.endsWith(".class")) {
            return new JavaTypeSource(src);
        }
        return src;
    }

    public static Source create(File file) {
        if (file.isDirectory()) {
            return new FolderSource(file);
        }
        return SourceFactory.wrap(new FileSource(file));
    }
}

