/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.sources;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.sources.SourceAdapter;

public class JavaTypeSource
extends SourceAdapter {
    private static final Map<String, String> versions = new HashMap<String, String>();

    public JavaTypeSource(Source source) {
        super(source);
    }

    @Override
    public String toString() {
        return "JavaTypeSource{" + super.toString() + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClassVersion(boolean convert) {
        String v = "?";
        try (InputStream m = this.openStream();){
            String string = JavaTypeSource.getClassVersion(m, convert);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getClassVersion(InputStream filename, boolean convert) throws IOException {
        DataInputStream in = new DataInputStream(filename);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a Java Class file");
        }
        int minor = in.readUnsignedShort();
        int major = in.readUnsignedShort();
        in.close();
        String s = major + "." + minor;
        if (convert) {
            String gg;
            String g = versions.get(s);
            if (g != null) {
                return g;
            }
            if (minor != 0 && (gg = versions.get(s)) != null) {
                return gg + "u" + minor;
            }
            return "#" + s;
        }
        return s;
    }

    public String getClassName() {
        String ii = this.getInternalPath();
        return ii.substring(0, ii.length() - ".class".length()).replace("/", ".");
    }

    static {
        versions.put("45.3", "1.1");
        versions.put("46.0", "1.2");
        versions.put("47.0", "1.3");
        versions.put("48.0", "1.4");
        for (int i = 5; i < 300; ++i) {
            versions.put(44 + i + ".0", i + ".0");
        }
    }
}

