/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.sources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.sources.SourceFactory;

public class FileSource
implements Source {
    private File file;

    public FileSource(File file) {
        this.file = file;
    }

    public String toString() {
        return "FileSource{" + this.file + '}';
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getExternalPath() {
        return this.file.getPath();
    }

    @Override
    public String getInternalPath() {
        return this.file.getPath();
    }

    @Override
    public Iterable<Source> getChildren() {
        ArrayList<Source> found = new ArrayList<Source>();
        File[] files = this.file.listFiles();
        if (files != null) {
            for (File f : files) {
                found.add(SourceFactory.create(f));
            }
        }
        return found;
    }

    @Override
    public boolean isStream() {
        return !this.file.isDirectory();
    }

    @Override
    public boolean isFolder() {
        return this.file.isDirectory();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.getFile());
    }
}

