/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.processors;

import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.SourceProcessor;
import net.thevpc.nuts.toolbox.ncode.sources.JavaTypeSource;

public class JavaSourceFormatter
implements SourceProcessor {
    private int clsNameSize = 20;

    @Override
    public Object process(Source source, NutsSession session) {
        if (source instanceof JavaTypeSource) {
            JavaTypeSource s = (JavaTypeSource)source;
            String v1 = s.getClassVersion(false);
            String v2 = s.getClassVersion(true);
            String n = s.getClassName();
            if (n.length() > this.clsNameSize) {
                this.clsNameSize = n.length();
            }
            return NutsMessage.cstyle((String)"%s %s %s %s", (Object[])new Object[]{NutsTexts.of((NutsSession)session).ofStyled(this.leftAlign(v1, 4), NutsTextStyle.config()), NutsTexts.of((NutsSession)session).ofStyled(this.leftAlign(v2, 4), NutsTextStyle.info()), NutsTexts.of((NutsSession)session).ofStyled(this.leftAlign(n, this.clsNameSize), NutsTextStyle.primary1()), NutsTexts.of((NutsSession)session).ofStyled(source.getExternalPath(), NutsTextStyle.path()), source.toString()});
        }
        return NutsMessage.cstyle((String)"%s : %s", (Object[])new Object[]{NutsTexts.of((NutsSession)session).ofStyled("invalid source", NutsTextStyle.error()), source.toString()});
    }

    private String leftAlign(String n, int size) {
        StringBuilder sb = new StringBuilder(size);
        sb.append(n);
        for (int x = size - n.length(); x > 0; --x) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

