/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.filters;

import java.util.List;
import net.thevpc.nuts.toolbox.ncode.Source;
import net.thevpc.nuts.toolbox.ncode.SourceFilter;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringComparator;
import net.thevpc.nuts.toolbox.ncode.sources.JavaTypeSource;
import net.thevpc.nuts.toolbox.ncode.sources.ZipEntrySource;
import net.thevpc.nuts.toolbox.ncode.sources.ZipSource;

public class JavaSourceFilter
implements SourceFilter {
    private final List<StringComparator> types;
    private final List<StringComparator> files;

    public JavaSourceFilter(List<StringComparator> types, List<StringComparator> files) {
        this.types = types;
        this.files = files;
    }

    private boolean matchesFile(String s) {
        if (this.files.isEmpty()) {
            return true;
        }
        for (StringComparator file : this.files) {
            if (!file.matches(s)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesType(String s) {
        if (this.files.isEmpty()) {
            return true;
        }
        for (StringComparator t : this.types) {
            if (!t.matches(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(Source source) {
        if (source instanceof JavaTypeSource) {
            String n;
            JavaTypeSource s = (JavaTypeSource)source;
            if (this.matchesFile(source.getExternalPath()) && this.matchesType(n = s.getClassName())) {
                return true;
            }
        } else if (source instanceof ZipSource) {
            String[] q;
            String n;
            ZipSource s = (ZipSource)source;
            if (this.matchesFile(source.getExternalPath()) && (n = s.getName()).endsWith(".class") && this.matchesType((q = (n = n.substring(0, n.length() - ".class".length())).split("[$]"))[0])) {
                return true;
            }
        } else if (source instanceof ZipEntrySource) {
            String[] q;
            String n;
            ZipEntrySource s = (ZipEntrySource)source;
            if (this.matchesFile(source.getExternalPath()) && (n = s.getName()).endsWith(".class") && this.matchesType((q = (n = n.substring(0, n.length() - ".class".length())).split("[$]"))[0])) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean lookInto(Source source) {
        return true;
    }
}

