/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.bundles.strings;

import java.text.Normalizer;
import java.util.regex.Pattern;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.AbstractStringTransform;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringTransform;

public class StringTransforms {
    public static final StringTransform LOWER = new LowerStringTransform();
    public static final StringTransform UNIFORM = new UniformStringTransform();
    public static final StringTransform TRIM = new TrimStringTransform();
    public static final StringTransform NOT_NULL = new NotNullStringTransform();
    public static final StringTransform TRIMMED_NOT_NULL = NOT_NULL.apply(TRIM);

    public static String normalizeString(String expression) {
        if (expression == null) {
            return null;
        }
        String nfdNormalizedString = Normalizer.normalize(expression, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static class NotNullStringTransform
    extends AbstractStringTransform {
        @Override
        public String transform(String s) {
            return s == null ? "" : s;
        }

        public String toString() {
            return "notnull";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }

    private static class TrimStringTransform
    extends AbstractStringTransform {
        @Override
        public String transform(String s) {
            return s == null ? null : s.trim();
        }

        public String toString() {
            return "trim";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }

    private static class UniformStringTransform
    extends AbstractStringTransform {
        @Override
        public String transform(String s) {
            s = StringTransforms.normalizeString(s);
            StringBuilder b = new StringBuilder();
            if (s != null) {
                boolean wasWhite = false;
                block6: for (char c : s.toCharArray()) {
                    if (Character.isWhitespace(c)) {
                        if (!wasWhite) {
                            b.append(" ");
                        }
                        wasWhite = true;
                        continue;
                    }
                    wasWhite = false;
                    c = Character.toLowerCase(c);
                    switch (c) {
                        case '\u00e8': 
                        case '\u00e9': 
                        case '\u00ea': 
                        case '\u00eb': {
                            b.append('e');
                            continue block6;
                        }
                        case '\u00e0': 
                        case '\u00e2': 
                        case '\u00e4': {
                            b.append('a');
                            continue block6;
                        }
                        case '\u00f9': 
                        case '\u00fb': 
                        case '\u00fc': {
                            b.append('u');
                            continue block6;
                        }
                        case '\u00ec': 
                        case '\u00ee': 
                        case '\u00ef': {
                            b.append('i');
                            continue block6;
                        }
                        default: {
                            b.append(c);
                        }
                    }
                }
            }
            return b.toString().trim();
        }

        public String toString() {
            return "uniform";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }

    private static class LowerStringTransform
    extends AbstractStringTransform {
        @Override
        public String transform(String s) {
            return s == null ? null : s.toLowerCase();
        }

        public String toString() {
            return "lower";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

