/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode.bundles.strings;

import java.util.Objects;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.AbstractStringComparator;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringComparator;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringTransforms;

public class StringComparators {
    public static StringComparator ilike(String pattern) {
        return StringComparators.like(pattern).apply(StringTransforms.LOWER);
    }

    public static StringComparator ilikepart(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (!pattern.startsWith("*")) {
            pattern = "*" + pattern;
        }
        if (!pattern.endsWith("*")) {
            pattern = pattern + "*";
        }
        return StringComparators.like(pattern).apply(StringTransforms.LOWER);
    }

    public static StringComparator ieq(String value) {
        return StringComparators.eq(value).apply(StringTransforms.LOWER);
    }

    public static StringComparator not(StringComparator other) {
        return new NotStringComparator(other);
    }

    public static StringComparator any() {
        return new AnyStringComparator();
    }

    public static StringComparator like(String pattern) {
        return new LikeStringComparator(pattern);
    }

    public static StringComparator eq(String pattern) {
        return new EqStringComparator(pattern);
    }

    public static StringComparator iregexp(String pattern) {
        return StringComparators.regexp(pattern).apply(StringTransforms.LOWER);
    }

    public static StringComparator regexp(String pattern) {
        return new RegexpStringComparator(pattern);
    }

    private static class RegexpStringComparator
    extends AbstractStringComparator {
        private final String pattern;

        public RegexpStringComparator(String pattern) {
            this.pattern = pattern;
        }

        @Override
        AbstractStringComparator copy() {
            return new RegexpStringComparator(this.pattern);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 29 * hash + Objects.hashCode(this.pattern);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            RegexpStringComparator other = (RegexpStringComparator)obj;
            return Objects.equals(this.pattern, other.pattern);
        }

        @Override
        public boolean matches(String value) {
            String pattern0 = this.pattern;
            if (this.getTransform() != null) {
                value = this.getTransform().transform(value);
                pattern0 = this.getTransform().transform(pattern0);
            }
            String v = value == null ? "" : value;
            String p = pattern0 == null ? "" : pattern0;
            return v.matches(p);
        }

        public String toString() {
            return "regexp(" + this.pattern + (this.getTransform() == null ? "" : "," + this.getTransform().toString()) + ")";
        }
    }

    private static class EqStringComparator
    extends AbstractStringComparator {
        private final String pattern;

        public EqStringComparator(String pattern) {
            this.pattern = pattern;
        }

        @Override
        AbstractStringComparator copy() {
            return new EqStringComparator(this.pattern);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 29 * hash + Objects.hashCode(this.pattern);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            EqStringComparator other = (EqStringComparator)obj;
            return Objects.equals(this.pattern, other.pattern);
        }

        @Override
        public boolean matches(String value) {
            String t_pattern = this.pattern;
            if (this.getTransform() != null) {
                value = this.getTransform().transform(value);
                t_pattern = this.getTransform().transform(t_pattern);
            }
            return value == t_pattern || value != null && value.equals(t_pattern);
        }

        public String toString() {
            return "eq(" + this.pattern + (this.getTransform() == null ? "" : "," + this.getTransform().toString()) + ")";
        }
    }

    private static class AnyStringComparator
    extends AbstractStringComparator {
        @Override
        AbstractStringComparator copy() {
            return new AnyStringComparator();
        }

        @Override
        public boolean matches(String value) {
            return true;
        }

        public String toString() {
            return "any";
        }
    }

    private static class LikeStringComparator
    extends AbstractStringComparator {
        private final String pattern;

        public LikeStringComparator(String pattern) {
            this.pattern = pattern;
        }

        @Override
        AbstractStringComparator copy() {
            return new LikeStringComparator(this.pattern);
        }

        private String compilePattern(String likePattern) {
            StringBuilder b = new StringBuilder();
            block6: for (char c : likePattern.toCharArray()) {
                switch (c) {
                    case '\\': {
                        b.append(c).append(c);
                        continue block6;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': {
                        b.append('\\').append(c);
                        continue block6;
                    }
                    case '*': {
                        b.append(".*");
                        continue block6;
                    }
                    case '?': {
                        b.append(".");
                        continue block6;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            return b.toString();
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 29 * hash + Objects.hashCode(this.pattern);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            LikeStringComparator other = (LikeStringComparator)obj;
            return Objects.equals(this.pattern, other.pattern);
        }

        @Override
        public boolean matches(String value) {
            String pattern0 = this.pattern;
            if (this.getTransform() != null) {
                value = this.getTransform().transform(value);
                pattern0 = this.getTransform().transform(pattern0);
            }
            pattern0 = this.compilePattern(pattern0);
            return value == null && pattern0.isEmpty() || value != null && value.matches(pattern0);
        }

        public String toString() {
            return "like(" + this.pattern + (this.getTransform() == null ? "" : "," + this.getTransform().toString()) + ")";
        }
    }

    private static class NotStringComparator
    extends AbstractStringComparator {
        private final StringComparator other;

        public NotStringComparator(StringComparator other) {
            this.other = other;
        }

        @Override
        AbstractStringComparator copy() {
            return new NotStringComparator(this.other);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 53 * hash + Objects.hashCode(this.other);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            NotStringComparator other = (NotStringComparator)obj;
            return Objects.equals(this.other, other.other);
        }

        @Override
        public boolean matches(String value) {
            if (this.getTransform() != null) {
                value = this.getTransform().transform(value);
            }
            return !this.other.matches(value);
        }

        public String toString() {
            return "not(" + this.other + (this.getTransform() == null ? "" : "," + this.getTransform().toString()) + ")";
        }
    }
}

