/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ncode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsAppCmdProcessor;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.ncode.SourceNavigator;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringComparator;
import net.thevpc.nuts.toolbox.ncode.bundles.strings.StringComparators;
import net.thevpc.nuts.toolbox.ncode.filters.JavaSourceFilter;
import net.thevpc.nuts.toolbox.ncode.filters.PathSourceFilter;
import net.thevpc.nuts.toolbox.ncode.processors.JavaSourceFormatter;
import net.thevpc.nuts.toolbox.ncode.processors.PathSourceFormatter;
import net.thevpc.nuts.toolbox.ncode.sources.SourceFactory;

class NCodeMainCmdProcessor
implements NutsAppCmdProcessor {
    List<String> paths = new ArrayList<String>();
    List<StringComparator> typeComparators = new ArrayList<StringComparator>();
    List<StringComparator> fileComparators = new ArrayList<StringComparator>();
    boolean caseInsensitive = false;

    NCodeMainCmdProcessor() {
    }

    public void onCmdInitParsing(NutsCommandLine commandline, NutsApplicationContext context) {
        commandline.setExpandSimpleOptions(true);
    }

    public boolean onCmdNextOption(NutsArgument option, NutsCommandLine commandline, NutsApplicationContext context) {
        switch (option.getStringKey()) {
            case "-i": {
                option = commandline.nextBoolean(new String[0]);
                this.caseInsensitive = option.getBooleanValue();
                return true;
            }
            case "-t": {
                this.typeComparators.add(this.comp(commandline.nextString(new String[0]).getStringValue()));
                return true;
            }
            case "-f": {
                this.fileComparators.add(this.comp(commandline.nextString(new String[0]).getStringValue()));
                return true;
            }
        }
        return false;
    }

    private StringComparator comp(String x) {
        StringComparator c;
        boolean negated = false;
        if (x.startsWith("!")) {
            negated = true;
            x = x.substring(1);
        }
        if (!x.startsWith("^")) {
            x = "*" + x;
        }
        if (!x.startsWith("$")) {
            x = x + "*";
        }
        StringComparator stringComparator = c = this.caseInsensitive ? StringComparators.ilike(x) : StringComparators.like(x);
        if (negated) {
            c = StringComparators.not(c);
        }
        return c;
    }

    public boolean onCmdNextNonOption(NutsArgument nonOption, NutsCommandLine commandline, NutsApplicationContext context) {
        this.paths.add(commandline.next().getString());
        return true;
    }

    public void onCmdExec(NutsCommandLine commandline, NutsApplicationContext context) {
        if (this.paths.isEmpty()) {
            this.paths.add(".");
        }
        if (this.typeComparators.isEmpty() && this.fileComparators.isEmpty()) {
            commandline.throwError(NutsMessage.plain((String)"missing filter"));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (!this.typeComparators.isEmpty()) {
            for (String path : this.paths) {
                SourceNavigator.navigate(SourceFactory.create(new File(path)), new JavaSourceFilter(this.typeComparators, this.fileComparators), new JavaSourceFormatter(), context.getSession(), results);
            }
        } else {
            for (String path : this.paths) {
                SourceNavigator.navigate(SourceFactory.create(new File(path)), new PathSourceFilter(this.fileComparators), new PathSourceFormatter(), context.getSession(), results);
            }
        }
        context.getSession().out().printlnf(results);
    }
}

